/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.HttpSchemes;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.util.IO;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

public class AsyncProxyServlet
implements Servlet {
    HttpClient _client;
    protected HashSet<String> _DontProxyHeaders = new HashSet();
    private ServletConfig config;
    private ServletContext context;

    public AsyncProxyServlet() {
        this._DontProxyHeaders.add("proxy-connection");
        this._DontProxyHeaders.add("connection");
        this._DontProxyHeaders.add("keep-alive");
        this._DontProxyHeaders.add("transfer-encoding");
        this._DontProxyHeaders.add("te");
        this._DontProxyHeaders.add("trailer");
        this._DontProxyHeaders.add("proxy-authorization");
        this._DontProxyHeaders.add("proxy-authenticate");
        this._DontProxyHeaders.add("upgrade");
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.context = config.getServletContext();
        this._client = new HttpClient();
        this._client.setConnectorType(2);
        try {
            this._client.start();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            this.handleConnect(request, response);
        } else {
            ServletInputStream in = request.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            final Continuation continuation = ContinuationSupport.getContinuation((HttpServletRequest)request, (Object)request);
            if (!continuation.isPending()) {
                final byte[] buffer = new byte[4096];
                String uri = request.getRequestURI();
                if (request.getQueryString() != null) {
                    uri = uri + "?" + request.getQueryString();
                }
                HttpExchange exchange = new HttpExchange((OutputStream)out, response){
                    final /* synthetic */ OutputStream val$out;
                    final /* synthetic */ HttpServletResponse val$response;
                    {
                        this.val$out = outputStream;
                        this.val$response = httpServletResponse;
                    }

                    protected void onRequestCommitted() throws IOException {
                        System.err.println("onRequestCommitted()");
                    }

                    protected void onRequestComplete() throws IOException {
                        System.err.println("onRequestComplete()");
                    }

                    protected void onResponseComplete() throws IOException {
                        System.err.println("onResponseComplete()");
                        continuation.resume();
                    }

                    protected void onResponseContent(Buffer content) throws IOException {
                        System.err.println("onResponseContent()");
                        while (content.hasContent()) {
                            int len = content.get(buffer, 0, buffer.length);
                            this.val$out.write(buffer, 0, len);
                        }
                    }

                    protected void onResponseHeaderComplete() throws IOException {
                        System.err.println("onResponseCompleteHeader()");
                    }

                    protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
                        System.err.println("onResponseStatus(" + version + "," + status + "," + reason + ")");
                        if (reason != null && reason.length() > 0) {
                            this.val$response.setStatus(status, reason.toString());
                        } else {
                            this.val$response.setStatus(status);
                        }
                    }

                    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
                        System.err.println("onResponseHeader(" + name + "," + value + ")");
                        String s = name.toString().toLowerCase();
                        if (!AsyncProxyServlet.this._DontProxyHeaders.contains(s)) {
                            this.val$response.addHeader(name.toString(), value.toString());
                        }
                    }
                };
                exchange.setScheme("https".equals(request.getScheme()) ? HttpSchemes.HTTPS_BUFFER : HttpSchemes.HTTP_BUFFER);
                exchange.setMethod(request.getMethod());
                exchange.setURI(uri);
                exchange.setVersion(request.getProtocol());
                InetSocketAddress address = new InetSocketAddress(request.getServerName(), request.getServerPort());
                exchange.setAddress(address);
                System.err.println("PROXY TO http://" + address.getHostName() + ":" + address.getPort() + uri);
                String connectionHdr = request.getHeader("Connection");
                if (connectionHdr != null && (connectionHdr = connectionHdr.toLowerCase()).indexOf("keep-alive") < 0 && connectionHdr.indexOf("close") < 0) {
                    connectionHdr = null;
                }
                boolean xForwardedFor = false;
                boolean hasContent = false;
                long contentLength = -1L;
                Enumeration enm = request.getHeaderNames();
                while (enm.hasMoreElements()) {
                    String hdr = (String)enm.nextElement();
                    String lhdr = hdr.toLowerCase();
                    if (this._DontProxyHeaders.contains(lhdr) || connectionHdr != null && connectionHdr.indexOf(lhdr) >= 0) continue;
                    if ("content-type".equals(lhdr)) {
                        hasContent = true;
                    }
                    if ("content-length".equals(lhdr)) {
                        contentLength = request.getContentLength();
                    }
                    Enumeration vals = request.getHeaders(hdr);
                    while (vals.hasMoreElements()) {
                        String val = (String)vals.nextElement();
                        if (val == null) continue;
                        exchange.setRequestHeader(lhdr, val);
                        xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
                    }
                }
                exchange.setRequestHeader("Via", "1.1 (jetty)");
                if (!xForwardedFor) {
                    exchange.addRequestHeader("X-Forwarded-For", request.getRemoteAddr());
                }
                if (hasContent) {
                    exchange.setRequestContentSource((InputStream)in);
                }
                this._client.send(exchange);
                continuation.suspend(30000L);
            }
        }
    }

    public void handleConnect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = request.getRequestURI();
        this.context.log("CONNECT: " + uri);
        String port = "";
        String host = "";
        int c = uri.indexOf(58);
        if (c >= 0) {
            port = uri.substring(c + 1);
            host = uri.substring(0, c);
            if (host.indexOf(47) > 0) {
                host = host.substring(host.indexOf(47) + 1);
            }
        }
        InetSocketAddress inetAddress = new InetSocketAddress(host, Integer.parseInt(port));
        ServletInputStream in = request.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        Socket socket = new Socket(inetAddress.getAddress(), inetAddress.getPort());
        this.context.log("Socket: " + socket);
        response.setStatus(200);
        response.setHeader("Connection", "close");
        response.flushBuffer();
        this.context.log("out<-in");
        IO.copyThread((InputStream)socket.getInputStream(), (OutputStream)out);
        this.context.log("in->out");
        IO.copy((InputStream)in, (OutputStream)socket.getOutputStream());
    }

    public String getServletInfo() {
        return "Proxy Servlet";
    }

    public void destroy() {
    }

    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        handlers.setHandlers(new Handler[]{contexts, new DefaultHandler()});
        server.setHandler((Handler)handlers);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/test");
        webapp.setResourceBase("../../webapps/test");
        contexts.addHandler((Handler)webapp);
        server.start();
        Server proxy = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setPort(8888);
        proxy.addConnector((Connector)connector);
        Context context = new Context((HandlerContainer)proxy, "/", 0);
        context.addServlet(new ServletHolder((Servlet)new AsyncProxyServlet()), "/");
        proxy.start();
        proxy.join();
    }
}

