/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpSchemes;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.log.Log;
import org.mortbay.util.StringUtil;

public class HttpExchange {
    public static final int STATUS_UNKOWN = 0;
    public static final int STATUS_WAITING_FOR_CONNECTION = 1;
    public static final int STATUS_WAITING_FOR_COMMIT = 2;
    public static final int STATUS_SENDING_REQUEST = 3;
    public static final int STATUS_WAITING_FOR_RESPONSE = 4;
    public static final int STATUS_PARSING_HEADERS = 5;
    public static final int STATUS_PARSING_CONTENT = 6;
    public static final int STATUS_COMPLETED = 7;
    public static final int STATUS_EXPIRED = 8;
    InetSocketAddress _address;
    String _method = "GET";
    Buffer _scheme;
    int _version = 11;
    String _uri;
    int _status = 0;
    HttpFields _requestFields = new HttpFields();
    Buffer _requestContent;
    InputStream _requestContentSource;
    Buffer _requestContentChunk;

    public int getStatus() {
        return this._status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStatus(int status) throws InterruptedException {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            while (this._status < status) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatus(int status) {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            this._status = status;
            this.notifyAll();
            try {
                switch (status) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.onRequestCommitted();
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        this.onResponseHeaderComplete();
                        break;
                    }
                    case 7: {
                        this.onResponseComplete();
                        break;
                    }
                    case 8: {
                        this.onExpire();
                    }
                }
            }
            catch (IOException e) {
                Log.warn((Throwable)e);
            }
        }
    }

    public void setURL(String url) {
        int port;
        HttpURI uri = new HttpURI(url);
        String scheme = uri.getScheme();
        if (scheme != null) {
            if ("http".equalsIgnoreCase(scheme)) {
                this.setScheme(HttpSchemes.HTTP_BUFFER);
            } else if ("https".equalsIgnoreCase(scheme)) {
                this.setScheme(HttpSchemes.HTTPS_BUFFER);
            } else {
                this.setScheme((Buffer)new ByteArrayBuffer(scheme));
            }
        }
        if ((port = uri.getPort()) <= 0) {
            port = "https".equalsIgnoreCase(scheme) ? 443 : 80;
        }
        this.setAddress(new InetSocketAddress(uri.getHost(), port));
        String completePath = uri.getCompletePath();
        if (completePath != null) {
            this.setURI(completePath);
        }
    }

    public void setAddress(InetSocketAddress address) {
        this._address = address;
    }

    public InetSocketAddress getAddress() {
        return this._address;
    }

    public void setScheme(Buffer scheme) {
        this._scheme = scheme;
    }

    public Buffer getScheme() {
        return this._scheme;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public void setVersion(String version) {
        BufferCache.CachedBuffer v = HttpVersions.CACHE.get(version);
        this._version = v == null ? 10 : v.getOrdinal();
    }

    public int getVersion() {
        return this._version;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public String getMethod() {
        return this._method;
    }

    public String getURI() {
        return this._uri;
    }

    public void setURI(String uri) {
        this._uri = uri;
    }

    public void addRequestHeader(String name, String value) {
        this.getRequestFields().add(name, value);
    }

    public void addRequestHeader(Buffer name, Buffer value) {
        this.getRequestFields().add(name, value);
    }

    public void setRequestHeader(String name, String value) {
        this.getRequestFields().put(name, value);
    }

    public void setRequestHeader(Buffer name, Buffer value) {
        this.getRequestFields().put(name, value);
    }

    public void setRequestContentType(String value) {
        this.getRequestFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, value);
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public void setRequestContent(Buffer requestContent) {
        this._requestContent = requestContent;
    }

    public void setRequestContentSource(InputStream in) {
        this._requestContentSource = in;
    }

    public InputStream getRequestContentSource() {
        return this._requestContentSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getRequestContentChunk() throws IOException {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this._requestContentChunk == null) {
                this._requestContentChunk = new ByteArrayBuffer(4096);
            } else {
                if (this._requestContentChunk.hasContent()) {
                    throw new IllegalStateException();
                }
                this._requestContentChunk.clear();
            }
            int read = this._requestContentChunk.capacity();
            int length = this._requestContentSource.read(this._requestContentChunk.array(), 0, read);
            if (length >= 0) {
                this._requestContentChunk.setPutIndex(length);
                return this._requestContentChunk;
            }
            return null;
        }
    }

    public Buffer getRequestContent() {
        return this._requestContent;
    }

    public String toString() {
        return "HttpExchange@" + this.hashCode() + "=" + this._method + "//" + this._address.getHostName() + ":" + this._address.getPort() + this._uri + "#" + this._status;
    }

    protected void onRequestCommitted() throws IOException {
    }

    protected void onRequestComplete() throws IOException {
    }

    protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
    }

    protected void onResponseHeaderComplete() throws IOException {
    }

    protected void onResponseContent(Buffer content) throws IOException {
    }

    protected void onResponseComplete() throws IOException {
    }

    protected void onConnectionFailed(Throwable ex) {
        System.err.println("CONNECTION FAILED on " + this);
    }

    protected void onException(Throwable ex) {
        System.err.println("EXCEPTION on " + this);
        ex.printStackTrace();
    }

    protected void onExpire() {
        System.err.println("EXPIRED " + this);
    }

    public static class ContentExchange
    extends CachedExchange {
        int _contentLength = 1024;
        String _encoding = "utf-8";
        ByteArrayOutputStream _responseContent;

        public ContentExchange() {
            super(false);
        }

        public String getResponseContent() throws UnsupportedEncodingException {
            if (this._responseContent != null) {
                return this._responseContent.toString(this._encoding);
            }
            return null;
        }

        protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
            int header = HttpHeaders.CACHE.getOrdinal(value);
            switch (header) {
                case 11: {
                    this._contentLength = BufferUtil.toInt((Buffer)value);
                    break;
                }
                case 16: {
                    String mime = StringUtil.asciiToLowerCase((String)value.toString());
                    int i = mime.indexOf("charset=");
                    if (i > 0 && (i = (mime = mime.substring(i + 8)).indexOf(59)) > 0) {
                        mime = mime.substring(0, i);
                    }
                    if (mime == null || mime.length() <= 0) break;
                    this._encoding = mime;
                }
            }
        }

        protected void onResponseContent(Buffer content) throws IOException {
            if (this._responseContent == null) {
                this._responseContent = new ByteArrayOutputStream(this._contentLength);
            }
            content.writeTo((OutputStream)this._responseContent);
        }
    }

    public static class CachedExchange
    extends HttpExchange {
        int _responseStatus;
        HttpFields _responseFields;

        public CachedExchange(boolean cacheFields) {
            if (cacheFields) {
                this._responseFields = new HttpFields();
            }
        }

        public int getResponseStatus() {
            if (this._status < 5) {
                throw new IllegalStateException("Response not received");
            }
            return this._responseStatus;
        }

        public HttpFields getResponseFields() {
            if (this._status < 6) {
                throw new IllegalStateException("Headers not complete");
            }
            return this._responseFields;
        }

        protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
            this._responseStatus = status;
        }

        protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
            if (this._responseFields != null) {
                this._responseFields.add(name, value);
            }
        }
    }
}

