/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpConnection;
import org.mortbay.jetty.client.HttpExchange;

public class HttpDestination {
    private ByteArrayBuffer _hostHeader;
    private InetSocketAddress _address;
    private LinkedList<HttpConnection> _connections = new LinkedList();
    private ArrayList<HttpConnection> _idle = new ArrayList();
    private HttpClient _client;
    private boolean _ssl;
    private int _maxConnections;
    private AtomicInteger _pendingConnections = new AtomicInteger(0);
    private LinkedList<HttpExchange> _queue = new LinkedList();

    HttpDestination(HttpClient pool, InetSocketAddress address, boolean ssl, int maxConnections) {
        this._client = pool;
        this._address = address;
        this._ssl = ssl;
        this._maxConnections = maxConnections;
        String host = address.getHostName();
        if (address.getPort() != (this._ssl ? 443 : 80)) {
            host = host + ":" + address.getPort();
        }
        this._hostHeader = new ByteArrayBuffer(host);
    }

    public InetSocketAddress getAddress() {
        return this._address;
    }

    public Buffer getHostHeader() {
        return this._hostHeader;
    }

    public HttpClient getHttpClient() {
        return this._client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpConnection getIdleConnection() throws IOException {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            long last;
            HttpConnection connection;
            long now = System.currentTimeMillis();
            long idleTimeout = this._client.getIdleTimeout();
            while (this._idle.size() > 0) {
                connection = this._idle.get(0);
                last = connection.getLast();
                if (connection.getEndPoint().isOpen() && now - last < idleTimeout) break;
                this._idle.remove(0);
                this._connections.remove(connection);
                connection.getEndPoint().close();
            }
            while (this._idle.size() > 0) {
                connection = this._idle.remove(this._idle.size() - 1);
                last = connection.getLast();
                if (connection.getEndPoint().isOpen() && (last == 0L || now - last < idleTimeout)) {
                    return connection;
                }
                this._connections.remove(connection);
                connection.getEndPoint().close();
            }
            return null;
        }
    }

    protected void startNewConnection() {
        try {
            this._pendingConnections.incrementAndGet();
            this._client._connector.startConnection(this);
        }
        catch (Exception e) {
            this.onException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionFailed(Throwable throwable) {
        this._pendingConnections.decrementAndGet();
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            if (this._queue.size() > 0) {
                HttpExchange ex = this._queue.removeFirst();
                ex.onConnectionFailed(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(Throwable throwable) {
        this._pendingConnections.decrementAndGet();
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            if (this._queue.size() > 0) {
                HttpExchange ex = this._queue.removeFirst();
                ex.onException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewConnection(HttpConnection connection) throws IOException {
        this._pendingConnections.decrementAndGet();
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            this._connections.add(connection);
            if (this._queue.size() == 0) {
                this._idle.add(connection);
            } else {
                HttpExchange ex = this._queue.removeFirst();
                connection.send(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(HttpConnection connection, boolean close) throws IOException {
        if (!close && connection.getEndPoint().isOpen()) {
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                if (this._queue.size() == 0) {
                    connection.setLast(System.currentTimeMillis());
                    this._idle.add(connection);
                } else {
                    HttpExchange ex = this._queue.removeFirst();
                    connection.send(ex);
                }
            }
        }
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            this._connections.remove(connection);
            if (!this._queue.isEmpty()) {
                this.startNewConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(HttpExchange ex) throws IOException {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            HttpConnection connection = null;
            if (this._queue.size() > 0 || (connection = this.getIdleConnection()) == null || !connection.send(ex)) {
                this._queue.add(ex);
                if (this._connections.size() + this._pendingConnections.get() < this._maxConnections) {
                    this.startNewConnection();
                }
            }
        }
    }

    public synchronized String toString() {
        return "HttpDestination@" + this.hashCode() + "//" + this._address.getHostName() + ":" + this._address.getPort() + "(" + this._connections.size() + "," + this._idle.size() + "," + this._queue.size() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toDetailString() {
        StringBuilder b = new StringBuilder();
        b.append(this.toString());
        b.append('\n');
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            for (HttpConnection connection : this._connections) {
                if (connection._exchange == null) continue;
                b.append(connection.toDetailString());
                if (this._idle.contains(connection)) {
                    b.append(" IDLE");
                }
                b.append('\n');
            }
        }
        b.append("--");
        b.append('\n');
        return b.toString();
    }
}

