/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.component.LifeCycle;
import org.mortbay.io.Buffer;
import org.mortbay.io.Buffers;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.bio.SocketEndPoint;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.io.nio.SelectorManager;
import org.mortbay.jetty.AbstractBuffers;
import org.mortbay.jetty.HttpSchemes;
import org.mortbay.jetty.client.HttpConnection;
import org.mortbay.jetty.client.HttpDestination;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.log.Log;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.thread.Timeout;

public class HttpClient
extends AbstractBuffers {
    public static final int CONNECTOR_SOCKET = 0;
    public static final int CONNECTOR_SELECT_CHANNEL = 2;
    private int _connectorType = 0;
    private boolean _useDirectBuffers = true;
    private int _maxConnectionsPerAddress = 32;
    private Map<InetSocketAddress, HttpDestination> _destinations = new HashMap<InetSocketAddress, HttpDestination>();
    ThreadPool _threadPool;
    Connector _connector;
    private long _idleTimeout = 20000L;
    private long _timeout = 320000L;
    private int _soTimeout = 10000;
    private Timeout _timeoutQ = new Timeout();

    public void send(HttpExchange exchange) throws IOException {
        boolean ssl = HttpSchemes.HTTPS_BUFFER.equalsIgnoreCase(exchange.getScheme());
        exchange.setStatus(1);
        HttpDestination destination = this.getDestination(exchange.getAddress(), ssl);
        destination.send(exchange);
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpDestination getDestination(InetSocketAddress remote, boolean ssl) throws UnknownHostException, IOException {
        if (remote == null) {
            throw new UnknownHostException("Remote socket address cannot be null.");
        }
        Map<InetSocketAddress, HttpDestination> map = this._destinations;
        synchronized (map) {
            HttpDestination destination = this._destinations.get(remote);
            if (destination == null) {
                destination = new HttpDestination(this, remote, ssl, this._maxConnectionsPerAddress);
                this._destinations.put(remote, destination);
            }
            return destination;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Timeout.Task task) {
        Timeout timeout = this._timeoutQ;
        synchronized (timeout) {
            this._timeoutQ.schedule(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Timeout.Task task) {
        Timeout timeout = this._timeoutQ;
        synchronized (timeout) {
            task.cancel();
        }
    }

    public boolean getUseDirectBuffers() {
        return this._useDirectBuffers;
    }

    public void setUseDirectBuffers(boolean direct) {
        this._useDirectBuffers = direct;
    }

    public int getConnectorType() {
        return this._connectorType;
    }

    public void setConnectorType(int connectorType) {
        this._connectorType = connectorType;
    }

    protected Buffer newBuffer(int size) {
        if (this._connectorType != 0) {
            NIOBuffer buf = null;
            buf = size == this.getHeaderBufferSize() ? new NIOBuffer(size, false) : new NIOBuffer(size, this._useDirectBuffers);
            return buf;
        }
        return new ByteArrayBuffer(size);
    }

    public int getMaxConnectionsPerAddress() {
        return this._maxConnectionsPerAddress;
    }

    public void setMaxConnectionsPerAddress(int maxConnectionsPerAddress) {
        this._maxConnectionsPerAddress = maxConnectionsPerAddress;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._timeoutQ.setNow();
        this._timeoutQ.setDuration(this._timeout);
        if (this._threadPool == null) {
            BoundedThreadPool pool = new BoundedThreadPool();
            pool.setMaxThreads(16);
            pool.setDaemon(true);
            this._threadPool = pool;
        }
        if (this._threadPool instanceof BoundedThreadPool) {
            ((BoundedThreadPool)this._threadPool).setName("HttpClient");
        }
        if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).start();
        }
        this._connector = this._connectorType == 2 ? new SelectConnector() : new SocketConnector();
        this._connector.start();
        this._threadPool.dispatch(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (HttpClient.this.isStarted()) {
                    Timeout timeout = HttpClient.this._timeoutQ;
                    synchronized (timeout) {
                        HttpClient.this._timeoutQ.setNow();
                        HttpClient.this._timeoutQ.tick();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
    }

    protected void doStop() throws Exception {
        this._connector.stop();
        this._connector = null;
        if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).stop();
        }
        this._timeoutQ.cancelAll();
        super.doStop();
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long ms) {
        this._idleTimeout = ms;
    }

    public int getSoTimeout() {
        return this._soTimeout;
    }

    public void setSoTimeout(int so) {
        this._soTimeout = so;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long ms) {
        this._timeout = ms;
    }

    class SelectConnector
    extends AbstractLifeCycle
    implements Connector,
    Runnable {
        SelectorManager _selectorManager = new Manager();

        SelectConnector() {
        }

        protected void doStart() throws Exception {
            this._selectorManager.start();
            HttpClient.this._threadPool.dispatch((Runnable)this);
        }

        protected void doStop() throws Exception {
            this._selectorManager.stop();
        }

        public void startConnection(HttpDestination destination) throws IOException {
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.connect(destination.getAddress());
            channel.socket().setSoTimeout(HttpClient.this._soTimeout);
            this._selectorManager.register(channel, (Object)destination);
        }

        public void run() {
            while (this.isRunning()) {
                try {
                    this._selectorManager.doSelect(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        class Manager
        extends SelectorManager {
            Manager() {
            }

            protected SocketChannel acceptChannel(SelectionKey key) throws IOException {
                throw new IllegalStateException();
            }

            public boolean dispatch(Runnable task) throws IOException {
                return HttpClient.this._threadPool.dispatch(task);
            }

            protected void endPointOpened(SelectChannelEndPoint endpoint) {
            }

            protected void endPointClosed(SelectChannelEndPoint endpoint) {
            }

            protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
                return new HttpConnection((Buffers)HttpClient.this, (EndPoint)endpoint, HttpClient.this.getHeaderBufferSize(), HttpClient.this.getRequestBufferSize());
            }

            protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
                HttpDestination dest = (HttpDestination)key.attachment();
                SelectChannelEndPoint ep = new SelectChannelEndPoint(channel, selectSet, key);
                HttpConnection connection = (HttpConnection)ep.getConnection();
                connection.setDestination(dest);
                dest.onNewConnection(connection);
                return ep;
            }

            protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
                if (attachment instanceof HttpDestination) {
                    ((HttpDestination)attachment).onConnectionFailed(ex);
                } else {
                    Log.warn((Throwable)ex);
                }
            }
        }
    }

    class SocketConnector
    extends AbstractLifeCycle
    implements Connector {
        SocketConnector() {
        }

        public void startConnection(final HttpDestination destination) throws IOException {
            Socket socket = new Socket();
            socket.connect(destination.getAddress());
            SocketEndPoint endpoint = new SocketEndPoint(socket);
            final HttpConnection connection = new HttpConnection((Buffers)HttpClient.this, (EndPoint)endpoint, HttpClient.this.getHeaderBufferSize(), HttpClient.this.getRequestBufferSize());
            connection.setDestination(destination);
            destination.onNewConnection(connection);
            HttpClient.this.getThreadPool().dispatch(new Runnable(){

                public void run() {
                    try {
                        connection.handle();
                    }
                    catch (IOException e) {
                        Log.warn((Throwable)e);
                        destination.onException(e);
                    }
                }
            });
        }
    }

    static interface Connector
    extends LifeCycle {
        public void startConnection(HttpDestination var1) throws IOException;
    }
}

