/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.client.HttpConnectionPool;

public class HttpExchange {
    InetSocketAddress _address;
    HttpConnectionPool _connectionPool;
    String _method;
    Buffer _requestContent;
    HttpFields _requestFields = new HttpFields();
    Buffer _responseContent;
    HttpFields _responseFields = new HttpFields();
    String _scheme;
    String _uri;

    public static void main(String[] args) throws IOException {
        HttpExchange ex = new HttpExchange(){

            protected void onProgress(Buffer content, boolean last) {
                System.err.println("Response content=" + content);
                super.onProgress(content, last);
            }

            protected void onSuccess(int status) {
                System.err.println("Response status=" + status);
                super.onSuccess(status);
            }
        };
        ex.setURL("http://localhost:8080/test/dump/info");
        ex.setMethod("GET");
        ex.setAddress(new InetSocketAddress("localhost", 8080));
        ex.setURI("/test/dump/info");
        ex.setRequestContentType("application/x-www-form-urlencoded");
        ex.addRequestHeader("arbitrary", "value");
        ex.setRequestContent((Buffer)new ByteArrayBuffer("param=value\n"));
        ex.send();
        ex.send(true);
    }

    public void addRequestHeader(String name, String value) {
        this.getRequestFields().add(name, value);
    }

    public InetSocketAddress getAddress() {
        return this._address;
    }

    public HttpConnectionPool getConnectionPool() {
        return this._connectionPool;
    }

    public String getMethod() {
        return this._method;
    }

    public Buffer getRequestContent() {
        return this._requestContent;
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public Buffer getResponseContent() {
        return this._responseContent;
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getURI() {
        return this._uri;
    }

    public boolean isIdemPotent() {
        return !"POST".equals(this._method);
    }

    public boolean isStreaming() {
        return false;
    }

    public void send() throws IOException {
        this.getConnectionPool().getConnection(this.getAddress(), "https".equalsIgnoreCase(this.getScheme()), true).send(this);
    }

    public void send(boolean pipeline) throws IOException {
        this.getConnectionPool().getConnection(this.getAddress(), "https".equalsIgnoreCase(this.getScheme()), !pipeline).send(this);
    }

    public void setAddress(InetSocketAddress address) {
        this._address = address;
    }

    public void setConnectionPool(HttpConnectionPool connectionPool) {
        this._connectionPool = connectionPool;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setRequestContent(Buffer requestContent) {
        this._requestContent = requestContent;
    }

    public void setRequestContentType(String value) {
        this.getRequestFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, value);
    }

    public void setResponseContent(Buffer responseContent) {
        this._responseContent = responseContent;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }

    public void setURI(String uri) {
        this._uri = uri;
    }

    public void setURL(String url) {
        int port;
        HttpURI uri = new HttpURI(url);
        String scheme = uri.getScheme();
        if (scheme != null) {
            this.setScheme(scheme);
        }
        if ((port = uri.getPort()) <= 0) {
            port = "https".equalsIgnoreCase(scheme) ? 443 : 80;
        }
        this.setAddress(new InetSocketAddress(uri.getHost(), port));
        String completePath = uri.getCompletePath();
        if (completePath != null) {
            this.setURI(completePath);
        }
    }

    protected void onProgress(Buffer content, boolean last) {
    }

    protected void onSuccess(int status) {
    }

    protected boolean refillRequestContent() {
        return this._requestContent != null && this._requestContent.hasContent();
    }
}

