/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import org.mortbay.jetty.client.HttpConnection;
import org.mortbay.jetty.client.HttpConnectionPool;
import org.mortbay.jetty.client.HttpExchange;

public class HttpDestination {
    private InetSocketAddress _address;
    private ArrayList<HttpConnection> _connections = new ArrayList();
    private LinkedList<HttpExchange> _exchanges = new LinkedList();
    private HttpConnectionPool _pool;

    HttpDestination(HttpConnectionPool pool, InetSocketAddress address) {
        this._pool = pool;
        this._address = address;
    }

    public InetSocketAddress getAddress() {
        return this._address;
    }

    public HttpConnection getConnection(boolean ssl, boolean blockForIdle) throws UnknownHostException, IOException {
        return this.newConnection(ssl);
    }

    public HttpConnection newConnection(boolean ssl) throws UnknownHostException, IOException {
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(false);
        channel.connect(this._address);
        return null;
    }

    public void send(HttpExchange ex) throws IOException {
        this._exchanges.add(ex);
    }

    public void setAddress(InetSocketAddress address) {
        this._address = address;
    }
}

