/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.util.LinkedList;
import org.mortbay.io.Buffer;
import org.mortbay.io.Buffers;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Generator;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.HttpParser;
import org.mortbay.jetty.client.HttpDestination;
import org.mortbay.jetty.client.HttpExchange;

public class HttpConnection {
    private HttpDestination _destination;
    private EndPoint _endp;
    private HttpExchange _exchange;
    private LinkedList<HttpExchange> _exchanges = new LinkedList();
    private Generator _generator;
    private HttpParser _parser;

    HttpConnection(HttpDestination destination, Buffers buffers, EndPoint endp, int hbs, int cbs) {
        this._destination = destination;
        this._endp = endp;
        this._generator = new HttpGenerator(buffers, endp, hbs, cbs);
        this._parser = new HttpParser(buffers, endp, (HttpParser.EventHandler)new Handler(), hbs, cbs);
    }

    public HttpDestination getDestination() {
        return this._destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws IOException {
        if (this._exchange == null) {
            this.nextExchange();
        }
        int no_progress = 0;
        while (this._endp.isOpen()) {
            try {
                long io = 0L;
                if (this._generator.isCommitted() && !this._generator.isComplete()) {
                    io += this._generator.flush();
                }
                if (this._endp.isBufferingOutput()) {
                    this._endp.flush();
                    if (this._endp.isBufferingOutput()) {
                        no_progress = 0;
                    }
                }
                if (!this._parser.isComplete()) {
                    io = this._parser.parseAvailable();
                }
                if (io > 0L) {
                    no_progress = 0;
                    continue;
                }
                if (no_progress++ < 2) continue;
                return;
            }
            catch (IOException e) {
                return;
            }
            finally {
                if (!this._parser.isComplete() || !this._generator.isComplete() || this._endp.isBufferingOutput()) continue;
                this._exchange = null;
                this.nextExchange();
                if (this._exchange != null) continue;
                this.reset(true);
            }
        }
    }

    public void send(HttpExchange ex) throws IOException {
        this._exchanges.add(ex);
    }

    private void nextExchange() throws IOException {
        if (this._exchange != null || this._exchanges.size() == 0) {
            return;
        }
        this._exchange = this._exchanges.remove(0);
        System.err.println("EX:" + this._exchange.getURI());
        this._generator.setVersion(11);
        this._generator.setRequest(this._exchange.getMethod(), this._exchange.getURI());
        if (this._exchange.getRequestContent() != null) {
            this._generator.addContent(this._exchange.getRequestContent(), true);
            this._generator.completeHeader(this._exchange.getRequestFields(), true);
            this._generator.complete();
        }
    }

    protected void reset(boolean returnBuffers) {
        this._parser.reset(returnBuffers);
        this._generator.reset(returnBuffers);
    }

    private class Handler
    extends HttpParser.EventHandler {
        private Handler() {
        }

        public void content(Buffer ref) throws IOException {
            System.err.println(ref);
        }

        public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
            throw new IllegalStateException();
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
            System.err.println(version + " " + status + " " + reason);
        }
    }
}

