/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import dojox.cometd.DataFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.filter.JSONDataFilter;
import org.mortbay.util.ajax.JSON;

public abstract class AbstractCometdServlet
extends HttpServlet {
    public static final String CLIENT_ATTR = "org.mortbay.cometd.client";
    public static final String TRANSPORT_ATTR = "org.mortbay.cometd.transport";
    public static final String MESSAGE_PARAM = "message";
    public static final String TUNNEL_INIT_PARAM = "tunnelInit";
    public static final String HTTP_CLIENT_ID = "BAYEUX_HTTP_CLIENT";
    public static final String BROWSER_ID = "BAYEUX_BROWSER";
    protected AbstractBayeux _bayeux;
    protected long _timeout = 45000L;

    public AbstractBayeux getBayeux() {
        return this._bayeux;
    }

    protected abstract AbstractBayeux newBayeux();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        Object object = AbstractCometdServlet.class;
        synchronized (AbstractCometdServlet.class) {
            this._bayeux = (AbstractBayeux)this.getServletContext().getAttribute("dojox.cometd.bayeux");
            if (this._bayeux == null) {
                this._bayeux = this.newBayeux();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = this._bayeux;
            synchronized (object) {
                boolean was_initialized = this._bayeux.isInitialized();
                this._bayeux.initialize(this.getServletContext());
                this.getServletContext().setAttribute("dojox.cometd.bayeux", (Object)this._bayeux);
                if (!was_initialized) {
                    String alwaysResumePoll;
                    String timeout;
                    String filters = this.getInitParameter("filters");
                    if (filters != null) {
                        try {
                            InputStream is = this.getServletContext().getResourceAsStream(filters);
                            if (is == null) {
                                throw new FileNotFoundException(filters);
                            }
                            Object[] objects = (Object[])JSON.parse((InputStream)this.getServletContext().getResourceAsStream(filters));
                            for (int i = 0; objects != null && i < objects.length; ++i) {
                                Map filter_def = (Map)objects[i];
                                Class<?> c = Thread.currentThread().getContextClassLoader().loadClass((String)filter_def.get("class"));
                                DataFilter filter = (DataFilter)c.newInstance();
                                if (filter instanceof JSONDataFilter) {
                                    ((JSONDataFilter)filter).init(filter_def.get("init"));
                                }
                                this._bayeux.addFilter((String)filter_def.get("channels"), filter);
                            }
                        }
                        catch (Exception e) {
                            this.getServletContext().log("Could not parse: " + filters, (Throwable)e);
                            throw new ServletException((Throwable)e);
                        }
                    }
                    if ((timeout = this.getInitParameter("timeout")) != null) {
                        this._timeout = Long.parseLong(timeout);
                    }
                    this._bayeux.setClientTimeoutMs(this._timeout * 3L / 2L);
                    String commentedJSON = this.getInitParameter("JSONCommented");
                    this._bayeux.setJSONCommented(commentedJSON != null && Boolean.parseBoolean(commentedJSON));
                    String l = this.getInitParameter("logLevel");
                    if (l != null && l.length() > 0) {
                        this._bayeux.setLogLevel(Integer.parseInt(l));
                    }
                    this._bayeux.setAlwaysResumePoll((alwaysResumePoll = this.getInitParameter("alwaysResumePoll")) != null && Boolean.parseBoolean(alwaysResumePoll));
                }
            }
            return;
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String init = req.getParameter(TUNNEL_INIT_PARAM);
        if ("iframe".equals(init)) {
            throw new IllegalStateException("Not supported");
        }
        super.service(req, resp);
    }

    protected String browserId(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!BROWSER_ID.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected String newBrowserId(HttpServletRequest request, HttpServletResponse response) {
        String browser_id = Long.toHexString(request.getRemotePort()) + Long.toHexString(this._bayeux.getRandom(request.hashCode())) + Long.toHexString(System.currentTimeMillis()) + Long.toHexString(request.getRemoteAddr().hashCode());
        Cookie cookie = new Cookie(BROWSER_ID, browser_id);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        response.addCookie(cookie);
        return browser_id;
    }
}

