/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.continuation;

import java.util.TimerTask;
import org.mortbay.cometd.ClientImpl;
import org.mortbay.cometd.continuation.ContinuationBayeux;
import org.mortbay.util.ajax.Continuation;

class ContinuationClient
extends ClientImpl {
    private long _accessed;
    private transient TimerTask _timeout;
    private ContinuationBayeux _bayeux;
    private transient Continuation _continuation;

    ContinuationClient(ContinuationBayeux bayeux) {
        super(bayeux, null, null);
        this._bayeux = bayeux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setContinuation(Continuation continuation) {
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            if (this._continuation != null && this._continuation.isPending()) {
                this._continuation.resume();
            }
            this._continuation = continuation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            if (this._continuation != null) {
                this._continuation.resume();
            }
            this._continuation = null;
        }
    }

    public boolean isLocal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access() {
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            this._accessed = System.currentTimeMillis();
            if (this._timeout != null) {
                this._timeout.cancel();
            }
            this._timeout = new TimerTask(){

                public void run() {
                    long now = System.currentTimeMillis();
                    if (ContinuationClient.this._accessed + ContinuationClient.this._bayeux.getClientTimeoutMs() < now) {
                        ContinuationClient.this.remove(true);
                    }
                }
            };
            this._bayeux._clientTimer.schedule(this._timeout, this._bayeux.getClientTimeoutMs());
        }
    }

    public void remove(boolean timeout) {
        if (!timeout) {
            this._timeout.cancel();
            this._timeout = null;
        }
        this.resume();
        super.remove(timeout);
    }
}

