/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.filter;

import dojox.cometd.Client;
import dojox.cometd.DataFilter;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.mortbay.cometd.ChannelImpl;
import org.mortbay.util.LazyList;
import org.mortbay.util.ajax.JSON;

public class JSONDataFilter
implements DataFilter {
    public void init(Object init) {
    }

    public Object filter(Client from, ChannelImpl to, Object data) throws IllegalStateException {
        if (data == null) {
            return null;
        }
        if (data instanceof Map) {
            return this.filterMap(from, to, (Map)data);
        }
        if (data instanceof List) {
            return this.filterArray(from, to, LazyList.toArray((Object)data, Object.class));
        }
        if (data.getClass().isArray()) {
            return this.filterArray(from, to, data);
        }
        if (data instanceof Number) {
            return this.filterNumber((Number)data);
        }
        if (data instanceof Boolean) {
            return this.filterBoolean((Boolean)data);
        }
        if (data instanceof String) {
            return this.filterString((String)data);
        }
        if (data instanceof JSON.Literal) {
            return this.filterJSON(from, to, (JSON.Literal)data);
        }
        return this.filterString(data.toString());
    }

    protected Object filterString(String string) {
        return string;
    }

    protected Object filterBoolean(Boolean bool) {
        return bool;
    }

    protected Object filterNumber(Number number) {
        return number;
    }

    protected Object filterArray(Client from, ChannelImpl to, Object array) {
        if (array == null) {
            return null;
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.filter(from, to, Array.get(array, i)));
        }
        return array;
    }

    protected Object filterMap(Client from, ChannelImpl to, Map object) {
        if (object == null) {
            return null;
        }
        for (Map.Entry entry : object.entrySet()) {
            entry.setValue(this.filter(from, to, entry.getValue()));
        }
        return object;
    }

    protected Object filterJSON(Client from, ChannelImpl to, JSON.Literal json) {
        Object data = JSON.parse((String)json.toString());
        return this.filter(from, to, data);
    }
}

