/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.ChannelId;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.DataFilter;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel {
    private Bayeux _bayeux;
    private Client[] _subscribers = new Client[0];
    private DataFilter[] _dataFilters = new DataFilter[0];
    private ChannelId _id;
    private ConcurrentMap<String, Channel> _children = new ConcurrentHashMap<String, Channel>();
    private Channel _wild;
    private Channel _wildWild;

    Channel(String id, Bayeux bayeux) {
        this._id = new ChannelId(id);
        this._bayeux = bayeux;
    }

    public void addChild(Channel channel) {
        ChannelId child = channel.getId();
        if (!this._id.isParentOf(child)) {
            throw new IllegalArgumentException(this._id + " not parent of " + child);
        }
        String next = child.getSegment(this._id.depth());
        if (child.depth() - this._id.depth() == 1) {
            Channel old = this._children.putIfAbsent(next, channel);
            if (old != null) {
                throw new IllegalArgumentException("Already Exists");
            }
            if ("*".equals(next)) {
                this._wild = channel;
            } else if ("**".equals(next)) {
                this._wildWild = channel;
            }
        } else {
            Channel branch = (Channel)this._children.get(next);
            branch = this._bayeux.getChannel((this._id.depth() == 0 ? "/" : this._id.toString() + "/") + next, true);
            branch.addChild(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Client client) {
        client.addSubscription(this);
        Channel channel = this;
        synchronized (channel) {
            this._subscribers = (Client[])LazyList.addToArray((Object[])this._subscribers, (Object)client, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(Client client) {
        client.removeSubscription(this);
        Channel channel = this;
        synchronized (channel) {
            this._subscribers = (Client[])LazyList.removeFromArray((Object[])this._subscribers, (Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataFilter(DataFilter filter) {
        Channel channel = this;
        synchronized (channel) {
            this._dataFilters = (DataFilter[])LazyList.addToArray((Object[])this._dataFilters, (Object)filter, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataFilter(DataFilter filter) {
        Channel channel = this;
        synchronized (channel) {
            this._dataFilters = (DataFilter[])LazyList.removeFromArray((Object[])this._dataFilters, (Object)filter);
        }
    }

    public ChannelId getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void publish(ChannelId to, Client from, Map<String, Object> msg) {
        String next;
        Channel channel;
        Object old;
        Object data;
        int tail;
        block32: {
            tail = to.depth() - this._id.depth();
            old = data = msg.get("data");
            DataFilter[] filters = null;
            try {
                block13 : switch (tail) {
                    case 0: {
                        Channel channel2 = this;
                        // MONITORENTER : channel2
                        filters = this._dataFilters;
                        // MONITOREXIT : channel2
                        for (DataFilter filter : filters) {
                            data = filter.filter(from, this, data);
                        }
                        break block32;
                    }
                    case 1: {
                        DataFilter[] arr$;
                        if (this._wild != null) {
                            arr$ = this._wild;
                            // MONITORENTER : this._wild
                            filters = this._wild._dataFilters;
                            // MONITOREXIT : arr$
                            for (DataFilter filter : filters) {
                                data = filter.filter(from, this, data);
                            }
                        }
                    }
                    default: {
                        if (this._wildWild == null) break block32;
                        DataFilter[] arr$ = this._wildWild;
                        // MONITORENTER : arr$
                        filters = this._wildWild._dataFilters;
                        // MONITOREXIT : arr$
                        arr$ = filters;
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (i$ < len$) {
                            DataFilter filter;
                            filter = arr$[i$];
                            data = filter.filter(from, this, data);
                            ++i$;
                            break block13;
                        }
                        break block32;
                    }
                }
                {
                    continue;
                    break;
                }
            }
            catch (IllegalStateException e) {
                Log.debug((Throwable)e);
                return;
            }
        }
        if (data != old) {
            msg.put("data", data);
        }
        boolean delivered = false;
        switch (tail) {
            case 0: {
                Channel i$ = this;
                // MONITORENTER : i$
                Client[] subscribers = this._subscribers;
                // MONITOREXIT : i$
                Client[] arr$ = subscribers;
                int len$ = arr$.length;
                int i$2 = 0;
                while (i$2 < len$) {
                    Client client = arr$[i$2];
                    client.deliver(from, to, msg);
                    delivered = true;
                    ++i$2;
                }
                return;
            }
            case 1: {
                if (this._wild == null) break;
                Client[] arr$ = this._wild;
                // MONITORENTER : this._wild
                Client[] subscribers = this._wild._subscribers;
                // MONITOREXIT : arr$
                arr$ = subscribers;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Client client = arr$[i$];
                    client.deliver(from, to, msg);
                    delivered = true;
                }
                break;
            }
        }
        if (this._wildWild != null) {
            Client[] arr$ = this._wildWild;
            // MONITORENTER : this._wildWild
            Client[] subscribers = this._wildWild._subscribers;
            // MONITOREXIT : arr$
            for (Client client : subscribers) {
                client.deliver(from, to, msg);
                delivered = true;
            }
        }
        if ((channel = (Channel)this._children.get(next = to.getSegment(this._id.depth()))) == null) return;
        if (delivered) {
            msg = new HashMap<String, Object>(msg);
        }
        channel.publish(to, from, msg);
    }

    public String getToken(Client client, boolean subscribe, boolean send, boolean oneTime) {
        String token = Long.toString(this._bayeux.getRandom(client.hashCode()), 36);
        return token;
    }

    public String toString() {
        return this._id.toString();
    }

    public Channel getChild(ChannelId id) {
        String next = id.getSegment(this._id.depth());
        if (next == null) {
            return null;
        }
        Channel channel = (Channel)this._children.get(next);
        if (channel == null || channel.getId().depth() == id.depth()) {
            return channel;
        }
        return channel.getChild(id);
    }
}

