/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.Channel;
import org.mortbay.cometd.ChannelId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    private Bayeux _bayeux;
    private String _id;
    private String _type;
    private Queue<Map<String, Object>> _messageQ = new LinkedList<Map<String, Object>>();
    private AtomicInteger _responsesPending = new AtomicInteger(0);
    private Channel _connection = null;
    private Set<Channel> _subscriptions = new CopyOnWriteArraySet<Channel>();
    private long _accessed;
    private transient TimerTask _timeout;
    private boolean _JSONCommented;

    public Client(Bayeux bayeux, String idPrefix) {
        this._bayeux = bayeux;
        this._id = idPrefix == null ? Long.toString(bayeux.getRandom((long)System.identityHashCode(this) ^ System.currentTimeMillis()), 36) : idPrefix + "_" + Long.toString(bayeux.getRandom((long)System.identityHashCode(this) ^ System.currentTimeMillis()), 36);
        this._bayeux._clients.put(this.getId(), this);
        if (this._bayeux.isLogInfo()) {
            this._bayeux.logInfo("newClient: " + this);
        }
    }

    public boolean isJSONCommented() {
        return this._JSONCommented;
    }

    public void setJSONCommented(boolean commented) {
        this._JSONCommented = commented;
    }

    public void remove() {
        this._bayeux.removeClient(this._id);
    }

    public String getConnectionType() {
        return this._type;
    }

    public String getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel connect() {
        Client client = this;
        synchronized (client) {
            String connection_id = "/meta/connections/" + this.getId();
            this._connection = this._bayeux.getChannel(connection_id, true);
            this._connection.addSubscriber(this);
            return this._connection;
        }
    }

    public Channel getConnection() {
        return this._connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessages() {
        Client client = this;
        synchronized (client) {
            return this._messageQ.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<Map<String, Object>> takeMessages() {
        Client client = this;
        synchronized (client) {
            if (this._messageQ.size() == 0) {
                return null;
            }
            Queue<Map<String, Object>> messages = this._messageQ;
            this._messageQ = new LinkedList<Map<String, Object>>();
            return messages;
        }
    }

    public String toString() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliver(Client from, ChannelId to, Map<String, Object> message) {
        Client client = this;
        synchronized (client) {
            if (this._connection != null) {
                this._messageQ.add(message);
                if (this._responsesPending.get() < 1) {
                    this.resume();
                }
            }
        }
    }

    public void resume() {
    }

    protected int responded() {
        return this._responsesPending.getAndDecrement();
    }

    protected int responsePending() {
        return this._responsesPending.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionType(String type) {
        Client client = this;
        synchronized (client) {
            this._type = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setId(String _id) {
        Client client = this;
        synchronized (client) {
            this._id = _id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubscription(Channel channel) {
        Client client = this;
        synchronized (client) {
            this._subscriptions.add(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(Channel channel) {
        Client client = this;
        synchronized (client) {
            this._subscriptions.remove(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void access() {
        Client client = this;
        synchronized (client) {
            this._accessed = System.currentTimeMillis();
            if (this._timeout != null) {
                this._timeout.cancel();
            }
            this._timeout = new TimerTask(){

                public void run() {
                    long now = System.currentTimeMillis();
                    if (Client.this._accessed + Client.this._bayeux.getClientTimeoutMs() < now) {
                        Client.this.remove();
                    }
                }
            };
            this._bayeux._clientTimer.schedule(this._timeout, this._bayeux.getClientTimeoutMs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribeAll() {
        Client client = this;
        synchronized (client) {
            this._messageQ.clear();
        }
        for (Channel channel : this._subscriptions) {
            channel.removeSubscriber(this);
        }
    }
}

