/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.cometd.AbstractTransport;
import org.mortbay.util.MultiPartWriter;
import org.mortbay.util.ajax.JSON;

public class MultiPartTransport
extends AbstractTransport {
    MultiPartWriter _writer;

    public void setResponse(HttpServletResponse response) throws IOException {
        super.setResponse(response);
        response.setCharacterEncoding("utf-8");
        this._writer = new MultiPartWriter((Writer)response.getWriter());
        response.setContentType(MultiPartWriter.MULTIPART_X_MIXED_REPLACE + "; boundary=" + this._writer.getBoundary());
    }

    public void send(Map reply) throws IOException {
        if (reply != null) {
            this._writer.startPart("text/plain; charset=utf-8");
            this._writer.write(JSON.toString((Map)reply));
            this._writer.flush();
        }
    }

    public void send(List replies) throws IOException {
        if (replies != null) {
            this._writer.startPart("text/plain; charset=utf-8");
            this._writer.write(JSON.toString((Object)replies));
            this._writer.endPart();
            this._writer.flush();
        }
    }

    public void complete() throws IOException {
        this._writer.close();
    }

    public boolean keepAlive() throws IOException {
        this._writer.startPart("text/plain; charset=utf-8");
        this._writer.write("{}");
        this._writer.flush();
        return false;
    }
}

