/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.mortbay.cometd.Channel;
import org.mortbay.cometd.ChannelPattern;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.DataFilter;
import org.mortbay.cometd.JSONPTransport;
import org.mortbay.cometd.PlainTextJSONTransport;
import org.mortbay.cometd.SecurityPolicy;
import org.mortbay.cometd.Transport;
import org.mortbay.util.DateCache;
import org.mortbay.util.ajax.JSON;

public class Bayeux {
    public static final String META_CONNECT = "/meta/connect";
    public static final String META_DISCONNECT = "/meta/disconnect";
    public static final String META_HANDSHAKE = "/meta/handshake";
    public static final String META_PING = "/meta/ping";
    public static final String META_RECONNECT = "/meta/reconnect";
    public static final String META_STATUS = "/meta/status";
    public static final String META_SUBSCRIBE = "/meta/subscribe";
    public static final String META_UNSUBSCRIBE = "/meta/unsubscribe";
    public static final String MONITOR_CHANNEL_EVENT = "/meta/monitor/channel/event";
    public static final String MONITOR_CLIENT_EVENT = "/meta/monitor/client/event";
    public static final String CLIENT_ATTR = "clientId";
    public static final String DATA_ATTR = "data";
    public static final String CHANNEL_ATTR = "channel";
    public static final String TIMESTAMP_ATTR = "timestamp";
    public static final String TRANSPORT_ATTR = "transport";
    public static final String ADVICE_ATTR = "advice";
    private static HashMap<String, Class> _transports = new HashMap();
    HashMap<String, Handler> _handlers = new HashMap();
    public static final JSON.Literal TRANSPORTS;
    private static final JSON.Literal __NO_ADVICE;
    ConcurrentHashMap<String, Channel> _channels = new ConcurrentHashMap();
    ConcurrentHashMap<String, Client> _clients = new ConcurrentHashMap();
    ConcurrentHashMap<ChannelPattern, DataFilter> _filters = new ConcurrentHashMap();
    ArrayList<ChannelPattern> _filterOrder = new ArrayList();
    SecurityPolicy _securityPolicy = new DefaultPolicy();
    Object _advice = new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":0}");
    Object _unknownAdvice = new JSON.Literal("{\"reconnect\":\"handshake\",\"interval\":500}");
    int _logLevel;
    transient ServletContext _context;
    transient Random _random;
    transient DateCache _dateCache;

    Bayeux() {
        this._handlers.put("*", new PublishHandler());
        this._handlers.put(META_HANDSHAKE, new HandshakeHandler());
        this._handlers.put(META_CONNECT, new ConnectHandler());
        this._handlers.put(META_RECONNECT, new ReconnectHandler());
        this._handlers.put(META_DISCONNECT, new DisconnectHandler());
        this._handlers.put(META_SUBSCRIBE, new SubscribeHandler());
        this._handlers.put(META_UNSUBSCRIBE, new UnsubscribeHandler());
        this._handlers.put(META_STATUS, new StatusHandler());
        this._handlers.put(META_PING, new PingHandler());
        this.newChannel(MONITOR_CHANNEL_EVENT);
        this.newChannel(MONITOR_CLIENT_EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(ServletContext context) {
        Bayeux bayeux = this;
        synchronized (bayeux) {
            this._context = context;
            try {
                this._random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (Exception e) {
                context.log("Could not get secure random for ID generation", (Throwable)e);
                this._random = new Random();
            }
            this._random.setSeed(this._random.nextLong() ^ (long)this.hashCode() ^ (long)(context.hashCode() << 32) ^ Runtime.getRuntime().freeMemory());
            this._dateCache = new DateCache();
        }
    }

    public Channel getChannel(String id) {
        return this._channels.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(String channels, DataFilter filter) {
        Bayeux bayeux = this;
        synchronized (bayeux) {
            ChannelPattern pattern = new ChannelPattern(channels);
            this._filters.put(pattern, filter);
            this._filterOrder.remove(pattern);
            this._filterOrder.add(pattern);
        }
    }

    public Channel newChannel(String id) {
        Channel channel = this._channels.get(id);
        if (channel == null) {
            channel = new Channel(id, this);
            for (ChannelPattern pattern : this._filterOrder) {
                if (!pattern.matches(id)) continue;
                channel.addDataFilter(this._filters.get(pattern));
            }
            this._channels.put(id, channel);
        }
        if (this.isLogInfo()) {
            this.logInfo("newChannel: " + channel);
        }
        return channel;
    }

    public Set getChannelIDs() {
        return this._channels.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClient(String client_id) {
        Bayeux bayeux = this;
        synchronized (bayeux) {
            if (client_id == null) {
                return null;
            }
            Client client = this._clients.get(client_id);
            if (client != null) {
                client.access();
            }
            return client;
        }
    }

    public synchronized Client newClient() {
        return this.newClient(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client newClient(String idPrefix) {
        Bayeux bayeux = this;
        synchronized (bayeux) {
            Client client = new Client(this, idPrefix);
            this._clients.put(client.getId(), client);
            if (this.isLogInfo()) {
                this.logInfo("newClient: " + client);
            }
            return client;
        }
    }

    public Set getClientIDs() {
        return this._clients.keySet();
    }

    String getTimeOnServer() {
        return this._dateCache.format(System.currentTimeMillis());
    }

    Transport newTransport(Client client, Map message) {
        if (this.isLogDebug()) {
            this.logDebug("newTransport: client=" + client + ",message=" + message);
        }
        Transport result = null;
        try {
            Class trans_class;
            String jsonp;
            String type;
            String string = type = client == null ? null : client.getConnectionType();
            if (type == null) {
                type = (String)message.get("connectionType");
            }
            if (type == null && (jsonp = (String)message.get("jsonp")) != null) {
                if (this.isLogDebug()) {
                    this.logDebug("newTransport: using JSONPTransport with jsonp=" + jsonp);
                }
                result = new JSONPTransport();
                ((JSONPTransport)result).setJsonp(jsonp);
            }
            if (type != null && result == null && (trans_class = _transports.get(type)) != null) {
                if (trans_class.equals(JSONPTransport.class)) {
                    String jsonp2 = (String)message.get("jsonp");
                    if (jsonp2 == null) {
                        throw new Exception("JSONPTransport needs jsonp parameter");
                    }
                    result = new JSONPTransport();
                    ((JSONPTransport)result).setJsonp(jsonp2);
                } else {
                    result = (Transport)trans_class.newInstance();
                }
            }
            if (result == null) {
                result = new PlainTextJSONTransport();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.isLogDebug()) {
            this.logDebug("newTransport: result=" + result);
        }
        return result;
    }

    void handle(Client client, Transport transport, Map message) throws IOException {
        String METHOD = "handle: ";
        String channel_id = (String)message.get(CHANNEL_ATTR);
        Handler handler = this._handlers.get(channel_id);
        if (handler == null) {
            handler = this._handlers.get("*");
        }
        if (this.isLogDebug()) {
            this.logDebug("handle: handler=" + handler);
        }
        handler.handle(client, transport, message);
    }

    void advise(Client client, Transport transport, Object advice) throws IOException {
        if (advice == null) {
            advice = this._advice;
        }
        if (advice == null) {
            advice = __NO_ADVICE;
        }
        String connection_id = "/meta/connections/" + client.getId();
        HashMap<String, Object> reply = new HashMap<String, Object>();
        reply.put(CHANNEL_ATTR, connection_id);
        reply.put("connectionId", connection_id);
        reply.put(TIMESTAMP_ATTR, this._dateCache.format(System.currentTimeMillis()));
        reply.put("successful", Boolean.TRUE);
        reply.put(ADVICE_ATTR, advice);
        transport.send(reply);
    }

    long getRandom(long variation) {
        long l = this._random.nextLong() ^ variation;
        return l < 0L ? -l : l;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._securityPolicy;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this._securityPolicy = securityPolicy;
    }

    public int getLogLevel() {
        return this._logLevel;
    }

    public void setLogLevel(int logLevel) {
        this._logLevel = logLevel;
    }

    public boolean isLogInfo() {
        return this._logLevel > 0;
    }

    public boolean isLogDebug() {
        return this._logLevel > 1;
    }

    public void logInfo(String message) {
        if (this._logLevel > 0) {
            this._context.log(message);
        }
    }

    public void logDebug(String message) {
        if (this._logLevel > 1) {
            this._context.log(message);
        }
    }

    public void logDebug(String message, Throwable th) {
        if (this._logLevel > 1) {
            this._context.log(message, th);
        }
    }

    static {
        _transports.put("long-polling", PlainTextJSONTransport.class);
        _transports.put("callback-polling", JSONPTransport.class);
        TRANSPORTS = new JSON.Literal("[\"long-polling\",\"callback-polling\"]");
        __NO_ADVICE = new JSON.Literal("{}");
    }

    private static class DefaultPolicy
    implements SecurityPolicy {
        private DefaultPolicy() {
        }

        public boolean canCreate(Client client, String channel_id, Map message) {
            return client != null && !channel_id.startsWith("/meta/");
        }

        public boolean canSubscribe(Client client, Channel channel, Map message) {
            return client != null && !channel.getId().startsWith("/meta/");
        }

        public boolean canSend(Client client, Channel channel, Map message) {
            return client != null && !channel.getId().startsWith("/meta/");
        }

        public boolean authenticate(String scheme, String user, String credentials) {
            return true;
        }
    }

    private class UnsubscribeHandler
    implements Handler {
        private UnsubscribeHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            if (client == null) {
                return;
            }
            String channel_id = (String)message.get("subscription");
            Channel channel = Bayeux.this.getChannel(channel_id);
            if (channel != null) {
                channel.removeSubscriber(client);
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_ATTR, channel_id);
            reply.put("subscription", channel.getId());
            reply.put("successful", Boolean.TRUE);
            reply.put("error", "");
            transport.send(reply);
            reply.put(Bayeux.CHANNEL_ATTR, message.get(Bayeux.CHANNEL_ATTR));
            Bayeux.this.getChannel(Bayeux.MONITOR_CHANNEL_EVENT).publish(reply, client);
        }
    }

    private class SubscribeHandler
    implements Handler {
        private SubscribeHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            Channel channel;
            if (client == null) {
                throw new IllegalStateException("No client");
            }
            String channel_id = (String)message.get("subscription");
            if (channel_id == null) {
                channel_id = Long.toString(Bayeux.this.getRandom(((Object)message).hashCode() ^ client.hashCode()), 36);
                while (Bayeux.this.getChannel(channel_id) != null) {
                    channel_id = Long.toString(Bayeux.this.getRandom(((Object)message).hashCode() ^ client.hashCode()), 36);
                }
            }
            if ((channel = Bayeux.this.getChannel(channel_id)) == null && Bayeux.this._securityPolicy.canCreate(client, channel_id, message)) {
                channel = Bayeux.this.newChannel(channel_id);
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_ATTR, channel_id);
            reply.put("subscription", channel.getId());
            if (channel != null && Bayeux.this._securityPolicy.canSubscribe(client, channel, message)) {
                channel.addSubscriber(client);
                reply.put("successful", Boolean.TRUE);
                reply.put("error", "");
            } else {
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "cannot subscribe");
            }
            transport.send(reply);
            reply.put(Bayeux.CHANNEL_ATTR, message.get(Bayeux.CHANNEL_ATTR));
            Bayeux.this.getChannel(Bayeux.MONITOR_CHANNEL_EVENT).publish(reply, client);
        }
    }

    private class StatusHandler
    implements Handler {
        private StatusHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
        }
    }

    private class ReconnectHandler
    implements Handler {
        private ReconnectHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            String connection_id = "/meta/connections/" + message.get(Bayeux.CLIENT_ATTR);
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_ATTR, Bayeux.META_RECONNECT);
            reply.put("connectionId", connection_id);
            reply.put(Bayeux.TIMESTAMP_ATTR, Bayeux.this._dateCache.format(System.currentTimeMillis()));
            if (client == null) {
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "unknown clientID");
                if (Bayeux.this._unknownAdvice != null) {
                    reply.put(Bayeux.ADVICE_ATTR, Bayeux.this._unknownAdvice);
                }
                transport.setPolling(false);
                transport.send(reply);
            } else {
                String type = (String)message.get("connectionType");
                if (type != null) {
                    if (Bayeux.this.isLogDebug()) {
                        Bayeux.this.logDebug("Reconnect.handle: old connectionType=" + client.getConnectionType());
                    }
                    if (client.getConnectionType().equals("callback-polling")) {
                        if (Bayeux.this.isLogDebug()) {
                            Bayeux.this.logDebug("Reconnect.handle: connectionType remains callback-polling");
                        }
                    } else {
                        client.setConnectionType(type);
                        if (Bayeux.this.isLogDebug()) {
                            Bayeux.this.logDebug("Reconnect.handle: connectionType reset to " + type);
                        }
                    }
                }
                reply.put("successful", Boolean.TRUE);
                reply.put("error", "");
                transport.setPolling(true);
                transport.send(reply);
            }
            Bayeux.this.getChannel(Bayeux.MONITOR_CLIENT_EVENT).publish(reply, client);
        }
    }

    private class PingHandler
    implements Handler {
        private PingHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
        }
    }

    private class HandshakeHandler
    implements Handler {
        private HandshakeHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            if (Bayeux.this.isLogDebug()) {
                Bayeux.this.logDebug("handshake.handle: client=" + client + ",transport=" + transport + ",message=" + message);
            }
            if (client != null) {
                throw new IllegalStateException();
            }
            if (Bayeux.this._securityPolicy.authenticate((String)message.get("authScheme"), (String)message.get("authUser"), (String)message.get("authToken"))) {
                client = Bayeux.this.newClient(null);
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_ATTR, Bayeux.META_HANDSHAKE);
            reply.put("version", new Double(0.1));
            reply.put("minimumVersion", new Double(0.1));
            if (client != null) {
                reply.put("supportedConnectionTypes", TRANSPORTS);
                reply.put("authSuccessful", Boolean.TRUE);
                reply.put(Bayeux.CLIENT_ATTR, client.getId());
                if (Bayeux.this._advice != null) {
                    reply.put(Bayeux.ADVICE_ATTR, Bayeux.this._advice);
                }
            } else {
                reply.put("authSuccessful", Boolean.FALSE);
                if (Bayeux.this._advice != null) {
                    reply.put(Bayeux.ADVICE_ATTR, Bayeux.this._advice);
                }
            }
            if (Bayeux.this.isLogDebug()) {
                Bayeux.this.logDebug("handshake.handle: reply=" + reply);
            }
            transport.send(reply);
        }
    }

    private class DisconnectHandler
    implements Handler {
        private DisconnectHandler() {
        }

        public void handle(Client client, Transport transport, Map message) {
        }
    }

    private class PublishHandler
    implements Handler {
        private PublishHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            String channel_id = (String)message.get(Bayeux.CHANNEL_ATTR);
            Channel channel = Bayeux.this.getChannel(channel_id);
            Object data = message.get(Bayeux.DATA_ATTR);
            if (client == null && Bayeux.this._securityPolicy.authenticate((String)message.get("authScheme"), (String)message.get("authUser"), (String)message.get("authToken"))) {
                client = Bayeux.this.newClient(null);
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_ATTR, channel_id);
            if (channel != null && data != null && Bayeux.this._securityPolicy.canSend(client, channel, message)) {
                channel.publish(data, client);
                reply.put("successful", Boolean.TRUE);
                reply.put("error", "");
            } else {
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "unknown channel");
            }
            transport.send(reply);
        }
    }

    private class ConnectHandler
    implements Handler {
        private ConnectHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            Channel connection;
            String METHOD = "handle: ";
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_ATTR, Bayeux.META_CONNECT);
            if (client == null) {
                throw new IllegalStateException("No client");
            }
            String type = (String)message.get("connectionType");
            client.setConnectionType(type);
            if (Bayeux.this.isLogDebug()) {
                Bayeux.this.logDebug("handle: connectionType set to " + type);
            }
            if ((connection = client.connect()) != null) {
                reply.put("successful", Boolean.TRUE);
                reply.put("error", "");
                reply.put("connectionId", connection.getId());
            } else {
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "unknown client ID");
                if (Bayeux.this._unknownAdvice != null) {
                    reply.put(Bayeux.ADVICE_ATTR, Bayeux.this._unknownAdvice);
                }
            }
            reply.put(Bayeux.TIMESTAMP_ATTR, Bayeux.this._dateCache.format(System.currentTimeMillis()));
            transport.send(reply);
            transport.setPolling(false);
            Bayeux.this.getChannel(Bayeux.MONITOR_CLIENT_EVENT).publish(reply, client);
        }
    }

    private static interface Handler {
        public void handle(Client var1, Transport var2, Map var3) throws IOException;
    }
}

