/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.cometd.AbstractTransport;
import org.mortbay.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONTransport
extends AbstractTransport {
    private int _responses = 0;
    private PrintWriter _out;
    protected String _contentType;
    protected String _start;
    protected String _end;
    private boolean _commented;

    public JSONTransport() {
        this.setJSONCommented(false);
    }

    public JSONTransport(boolean commented) {
        this.setJSONCommented(commented);
    }

    @Override
    public boolean isJSONCommented() {
        return this._commented;
    }

    @Override
    public void setJSONCommented(boolean commented) {
        this._commented = commented;
        if (commented) {
            this._contentType = "text/json-comment-filtered; charset=utf-8";
            this._start = "/*[";
            this._end = "]*/\r\n";
        } else {
            this._contentType = "text/json charset=utf-8";
            this._start = "[";
            this._end = "]\r\n";
        }
    }

    @Override
    public void send(Map<String, Object> reply) throws IOException {
        if (reply != null) {
            if (this._responses == 0) {
                HttpServletResponse response = this.getResponse();
                response.setContentType(this._contentType);
                this._out = response.getWriter();
                this._out.write(this._start);
            } else {
                this._out.write(44);
            }
            String r = JSON.toString(reply);
            ++this._responses;
            this._out.write(r);
        }
    }

    @Override
    public void complete() throws IOException {
        HttpServletResponse response = this.getResponse();
        response.setStatus(200);
        if (this._responses == 0) {
            response.setContentLength(0);
        } else {
            this._out.write(this._end);
        }
    }

    @Override
    public boolean keepAlive() throws IOException {
        return false;
    }
}

