/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.filter;

import java.lang.reflect.Array;
import java.util.regex.Pattern;
import org.mortbay.cometd.filter.JSONDataFilter;

public class RegexFilter
extends JSONDataFilter {
    Pattern[] _patterns;
    String[] _replaces;

    public void init(Object init) {
        super.init(init);
        this._patterns = new Pattern[Array.getLength(init)];
        this._replaces = new String[this._patterns.length];
        for (int i = 0; i < this._patterns.length; ++i) {
            Object entry = Array.get(init, i);
            this._patterns[i] = Pattern.compile((String)Array.get(entry, 0));
            this._replaces[i] = (String)Array.get(entry, 1);
        }
    }

    protected Object filterString(String string) {
        for (int i = 0; i < this._patterns.length; ++i) {
            if (this._replaces[i] != null) {
                string = this._patterns[i].matcher(string).replaceAll(this._replaces[i]);
                continue;
            }
            if (!this._patterns[i].matcher(string).matches()) continue;
            throw new IllegalStateException("matched " + this._patterns[i] + " in " + string);
        }
        return string;
    }
}

