/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.cometd.AbstractTransport;
import org.mortbay.cometd.JSON;

public class PlainTextJSONTransport
extends AbstractTransport {
    int _responses = 0;
    PrintWriter _out;
    boolean _verbose;

    public void send(Map reply) throws IOException {
        if (reply != null) {
            if (this._responses == 0) {
                HttpServletResponse response = this.getResponse();
                response.setContentType("text/plain; charset=utf-8");
                this._out = response.getWriter();
                this._out.write(91);
            } else {
                this._out.write(",\r\n");
            }
            String r = JSON.toString(reply);
            if (this._verbose) {
                System.err.println("<=" + this._responses + "=" + r);
            }
            ++this._responses;
            this._out.write(r);
        }
    }

    public void send(List replies) throws IOException {
        super.send(replies);
    }

    public void complete() throws IOException {
        HttpServletResponse response = this.getResponse();
        response.setStatus(200);
        if (this._responses == 0) {
            response.setContentLength(0);
        } else {
            if (this._verbose) {
                System.err.println("<=-=");
            }
            this._out.write("]\r\n");
            this._out.flush();
        }
    }

    public boolean keepAlive() throws IOException {
        return false;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }
}

