/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.DataFilter;
import org.mortbay.cometd.IFrameTransport;
import org.mortbay.cometd.JSON;
import org.mortbay.cometd.Transport;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

public class CometdServlet
extends HttpServlet {
    public static final String ORG_MORTBAY_BAYEUX = "org.mortbay.bayeux";
    public static final String CLIENT_ATTR = "org.mortbay.cometd.client";
    public static final String MESSAGE_PARAM = "message";
    public static final String TUNNEL_INIT_PARAM = "tunnelInit";
    public static final String BROWSER_ID = "bayeuxBID";
    private Bayeux _bayeux;
    private long _timeout = 45000L;
    private long _multiTimeout = 0L;
    private Map _bidCount = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        String multiTimeout;
        String timeout;
        Class clazz = CometdServlet.class;
        synchronized (clazz) {
            this._bayeux = (Bayeux)this.getServletContext().getAttribute(ORG_MORTBAY_BAYEUX);
            if (this._bayeux == null) {
                this._bayeux = new Bayeux(this.getServletContext());
                this.getServletContext().setAttribute(ORG_MORTBAY_BAYEUX, (Object)this._bayeux);
            }
        }
        String filters = this.getInitParameter("filters");
        if (filters != null) {
            try {
                Object[] objects = (Object[])JSON.parse(this.getServletContext().getResourceAsStream(filters));
                for (int i = 0; objects != null && i < objects.length; ++i) {
                    Map filter_def = (Map)objects[i];
                    Class<?> c = Thread.currentThread().getContextClassLoader().loadClass((String)filter_def.get("class"));
                    DataFilter filter = (DataFilter)c.newInstance();
                    filter.init(filter_def.get("init"));
                    this._bayeux.addFilter((String)filter_def.get("channels"), filter);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getServletContext().log("Could not parse: " + filters, (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
        if ((timeout = this.getInitParameter("timeout")) != null) {
            this._timeout = Long.parseLong(timeout);
        }
        if ((multiTimeout = this.getInitParameter("multi-timeout")) != null) {
            this._multiTimeout = Long.parseLong(multiTimeout);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String init = req.getParameter(TUNNEL_INIT_PARAM);
        if ("iframe".equals(init)) {
            IFrameTransport transport = new IFrameTransport();
            transport.initTunnel(resp);
        } else {
            super.service(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Transport transport;
        String bid = null;
        if (this._multiTimeout > 0L) {
            Cookie[] cookies = req.getCookies();
            for (int i = 0; cookies != null && i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(BROWSER_ID)) continue;
                bid = cookies[i].getValue();
            }
            if (bid == null) {
                long l1 = this._bayeux._random.nextLong();
                long l2 = this._bayeux._random.nextLong();
                bid = Long.toString(l1 < 0L ? -l1 : l1, 16) + Long.toString(l2 < 0L ? -l2 : l2, 16);
                Cookie cookie = new Cookie(BROWSER_ID, bid);
                cookie.setPath("/");
                resp.addCookie(cookie);
            }
        }
        int message_count = 0;
        Object clientObj = req.getAttribute(CLIENT_ATTR);
        Client client = clientObj instanceof Client ? (Client)clientObj : null;
        Transport transport2 = transport = client == null ? null : (Transport)req.getAttribute("transport");
        if (client == null) {
            String[] messages = req.getParameterValues(MESSAGE_PARAM);
            Object objects = null;
            int index = 0;
            for (int m = 0; m < messages.length; ++m) {
                System.err.println("=" + m + "=>" + messages[m]);
                if (objects == null) {
                    index = 0;
                    objects = JSON.parse(messages[m]);
                }
                if (objects == null) continue;
                Object object = objects;
                if (objects.getClass().isArray()) {
                    if (index >= Array.getLength(objects)) {
                        objects = null;
                        continue;
                    }
                    object = Array.get(objects, index++);
                } else {
                    objects = null;
                }
                ++message_count;
                Map message = (Map)object;
                if (client == null) {
                    client = this._bayeux.getClient((String)message.get("clientId"));
                    req.setAttribute(CLIENT_ATTR, (Object)client);
                }
                if (transport == null) {
                    transport = this._bayeux.newTransport(client, message);
                    req.setAttribute("transport", (Object)transport);
                }
                transport.setResponse(resp);
                this._bayeux.handle(client, transport, message);
            }
        }
        Continuation continuation = null;
        try {
            while (client != null && transport != null && transport.isPolling()) {
                long timeout = this._timeout;
                continuation = ContinuationSupport.getContinuation((HttpServletRequest)req, (Object)client);
                try {
                    if (bid != null && !continuation.isPending() && this.incBID(bid) > 1) {
                        timeout = this._multiTimeout;
                        this._bayeux.advise(client, transport, new JSON.Literal("{\"status\":\"multipleconnections\",\"reconnect\":\"retry\",\"interval\":" + this._multiTimeout + ",\"transport\":{\"long-polling\":{}}}"));
                    }
                    Client client2 = client;
                    synchronized (client2) {
                        client.addContinuation(continuation);
                        if (!client.hasMessages()) {
                            continuation.suspend(timeout);
                        }
                        client.removeContinuation(continuation);
                        continuation.reset();
                        if (client.hasMessages()) {
                            List messages = client.takeMessages();
                            transport.send(messages);
                        } else {
                            transport.setPolling(false);
                        }
                        if (!transport.keepAlive()) {
                            transport.setPolling(false);
                        }
                    }
                }
                finally {
                    if (bid == null || continuation != null && continuation.isPending() || this.decBID(bid) != 0) continue;
                    this._bayeux.advise(client, transport, null);
                }
            }
            return;
        }
        finally {
            if (!(continuation != null && continuation.isPending() || transport == null)) {
                transport.complete();
                transport.setPolling(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incBID(String bid) {
        Map map = this._bidCount;
        synchronized (map) {
            Integer count = (Integer)this._bidCount.get(bid);
            count = TypeUtil.newInteger((int)(count == null ? 1 : count + 1));
            this._bidCount.put(bid, count);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decBID(String bid) {
        Map map = this._bidCount;
        synchronized (map) {
            Integer count = (Integer)this._bidCount.get(bid);
            Integer n = count = count == null || count <= 1 ? null : TypeUtil.newInteger((int)(count - 1));
            if (count == null) {
                this._bidCount.remove(bid);
                return 0;
            }
            this._bidCount.put(bid, count);
            return count;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }
}

