/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.util.HashMap;
import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.DataFilter;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public class Channel {
    private Bayeux _bayeux;
    private String _id;
    private long _nextMsgId;
    private Object _subscribers = null;
    private Object _dataFilters = null;

    Channel(String id, Bayeux bayeux) {
        this._id = id;
        this._bayeux = bayeux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Client client) {
        Channel channel = this;
        synchronized (channel) {
            this._subscribers = LazyList.add((Object)this._subscribers, (Object)client);
        }
    }

    public void addDataFilter(DataFilter filter) {
        this._dataFilters = LazyList.add((Object)this._dataFilters, (Object)filter);
    }

    public void removeDataFilter(DataFilter filter) {
        this._dataFilters = LazyList.remove((Object)this._dataFilters, (Object)filter);
    }

    public String getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscriber(Client client) {
        Channel channel = this;
        synchronized (channel) {
            this._subscribers = LazyList.remove((Object)this._subscribers, (Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Object data, Client from) {
        try {
            for (int f = 0; f < LazyList.size((Object)this._dataFilters); ++f) {
                data = ((DataFilter)LazyList.get((Object)this._dataFilters, (int)f)).filter(data, from);
                if (data != null) continue;
                return;
            }
        }
        catch (IllegalStateException e) {
            Log.debug((Throwable)e);
            return;
        }
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("channel", this._id);
        msg.put("data", data);
        msg.put("timestamp", this._bayeux.getTimeOnServer());
        Channel channel = this;
        synchronized (channel) {
            long id = this.hashCode() * msg.hashCode();
            id = id < 0L ? -id : id;
            msg.put("id", Long.toString(id, 36) + Long.toString(this._nextMsgId++, 36));
            int subscribers = LazyList.size((Object)this._subscribers);
            for (int i = 0; i < subscribers; ++i) {
                ((Client)LazyList.get((Object)this._subscribers, (int)i)).deliver(msg);
            }
        }
    }

    public String getToken(Client client, boolean subscribe, boolean send, boolean oneTime) {
        String token = Long.toString(this._bayeux.getRandom(client.hashCode()), 36);
        return token;
    }

    public String toString() {
        return this._id + "(" + this._subscribers + ")";
    }
}

