/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cometd.Bayeux;
import org.cometd.Channel;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.mortbay.cometd.ChannelImpl;
import org.mortbay.cometd.MessageImpl;
import org.mortbay.component.LifeCycle;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BayeuxService {
    private String _name;
    private Bayeux _bayeux;
    private Client _client;
    private Map<String, Method> _methods = new ConcurrentHashMap<String, Method>();
    private ThreadPool _threadPool;
    private MessageListener _listener;
    private boolean _seeOwn = false;

    public BayeuxService(Bayeux bayeux, String name) {
        this(bayeux, name, 0, false);
    }

    public BayeuxService(Bayeux bayeux, String name, int maxThreads) {
        this(bayeux, name, maxThreads, false);
    }

    public BayeuxService(Bayeux bayeux, String name, int maxThreads, boolean synchronous) {
        if (maxThreads > 0) {
            this.setThreadPool((ThreadPool)new QueuedThreadPool(maxThreads));
        }
        this._name = name;
        this._bayeux = bayeux;
        this._client = this._bayeux.newClient(name);
        this._listener = synchronous ? new SyncListen() : new AsyncListen();
        this._client.addListener((ClientListener)this._listener);
    }

    public Bayeux getBayeux() {
        return this._bayeux;
    }

    public Client getClient() {
        return this._client;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool pool) {
        try {
            if (pool instanceof LifeCycle && !((LifeCycle)pool).isStarted()) {
                ((LifeCycle)pool).start();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this._threadPool = pool;
    }

    public boolean isSeeOwnPublishes() {
        return this._seeOwn;
    }

    public void setSeeOwnPublishes(boolean own) {
        this._seeOwn = own;
    }

    protected void subscribe(String channelId, String methodName) {
        Method method = null;
        for (Class<?> c = this.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            Method[] methods = c.getDeclaredMethods();
            int i = methods.length;
            while (i-- > 0) {
                if (!methodName.equals(methods[i].getName())) continue;
                if (method != null) {
                    throw new IllegalArgumentException("Multiple methods called '" + methodName + "'");
                }
                method = methods[i];
            }
        }
        if (method == null) {
            throw new NoSuchMethodError(methodName);
        }
        int params = method.getParameterTypes().length;
        if (params < 2 || params > 4) {
            throw new IllegalArgumentException("Method '" + methodName + "' does not have 2or3 parameters");
        }
        if (!Client.class.isAssignableFrom(method.getParameterTypes()[0])) {
            throw new IllegalArgumentException("Method '" + methodName + "' does not have Client as first parameter");
        }
        Channel channel = this._bayeux.getChannel(channelId, true);
        if (((ChannelImpl)channel).getChannelId().isWild()) {
            Method m = method;
            Client wild_client = this._bayeux.newClient(this._name + "-wild");
            wild_client.addListener((ClientListener)(this._listener instanceof MessageListener.Asynchronous ? new AsyncWildListen(wild_client, m) : new SyncWildListen(wild_client, m)));
            channel.subscribe(wild_client);
        } else {
            this._methods.put(channelId, method);
            channel.subscribe(this._client);
        }
    }

    protected void send(Client toClient, String onChannel, Object data, String id) {
        toClient.deliver(this.getClient(), onChannel, data, id);
    }

    protected void exception(Client fromClient, Client toClient, Map<String, Object> msg, Throwable th) {
        System.err.println(msg);
        th.printStackTrace();
    }

    private void invoke(final Method method, final Client fromClient, final Client toClient, final Message msg) {
        if (this._threadPool == null) {
            this.doInvoke(method, fromClient, toClient, msg);
        } else {
            this._threadPool.dispatch(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ((MessageImpl)msg).incRef();
                        BayeuxService.this.doInvoke(method, fromClient, toClient, msg);
                    }
                    finally {
                        ((MessageImpl)msg).decRef();
                    }
                }
            });
        }
    }

    private void doInvoke(Method method, Client fromClient, Client toClient, Message msg) {
        String channel = (String)msg.get((Object)"channel");
        Object data = msg.get((Object)"data");
        String id = msg.getId();
        if (method != null) {
            try {
                Class<?>[] args = method.getParameterTypes();
                Object arg = Message.class.isAssignableFrom(args[1]) ? msg : data;
                Object reply = null;
                switch (method.getParameterTypes().length) {
                    case 2: {
                        reply = method.invoke((Object)this, fromClient, arg);
                        break;
                    }
                    case 3: {
                        reply = method.invoke((Object)this, fromClient, arg, id);
                        break;
                    }
                    case 4: {
                        reply = method.invoke((Object)this, fromClient, channel, arg, id);
                    }
                }
                if (reply != null) {
                    this.send(fromClient, channel, reply, id);
                }
            }
            catch (Exception e) {
                System.err.println(method);
                this.exception(fromClient, toClient, (Map<String, Object>)msg, e);
            }
            catch (Error e) {
                System.err.println(method);
                this.exception(fromClient, toClient, (Map<String, Object>)msg, e);
            }
        }
    }

    private class AsyncWildListen
    implements MessageListener,
    MessageListener.Asynchronous {
        Client _client;
        Method _method;

        public AsyncWildListen(Client client, Method method) {
            this._client = client;
            this._method = method;
        }

        public void deliver(Client fromClient, Client toClient, Message msg) {
            if (!(BayeuxService.this._seeOwn || fromClient != this._client && fromClient != BayeuxService.this.getClient())) {
                return;
            }
            BayeuxService.this.invoke(this._method, fromClient, toClient, msg);
        }
    }

    private class SyncWildListen
    implements MessageListener,
    MessageListener.Synchronous {
        Client _client;
        Method _method;

        public SyncWildListen(Client client, Method method) {
            this._client = client;
            this._method = method;
        }

        public void deliver(Client fromClient, Client toClient, Message msg) {
            if (!(BayeuxService.this._seeOwn || fromClient != this._client && fromClient != BayeuxService.this.getClient())) {
                return;
            }
            BayeuxService.this.invoke(this._method, fromClient, toClient, msg);
        }
    }

    private class SyncListen
    implements MessageListener,
    MessageListener.Synchronous {
        private SyncListen() {
        }

        public void deliver(Client fromClient, Client toClient, Message msg) {
            if (!BayeuxService.this._seeOwn && fromClient == BayeuxService.this.getClient()) {
                return;
            }
            String channel = (String)msg.get((Object)"channel");
            Method method = (Method)BayeuxService.this._methods.get(channel);
            BayeuxService.this.invoke(method, fromClient, toClient, msg);
        }
    }

    private class AsyncListen
    implements MessageListener,
    MessageListener.Asynchronous {
        private AsyncListen() {
        }

        public void deliver(Client fromClient, Client toClient, Message msg) {
            if (!BayeuxService.this._seeOwn && fromClient == BayeuxService.this.getClient()) {
                return;
            }
            String channel = (String)msg.get((Object)"channel");
            Method method = (Method)BayeuxService.this._methods.get(channel);
            BayeuxService.this.invoke(method, fromClient, toClient, msg);
        }
    }
}

