/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.DataFilter;
import org.cometd.Message;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.filter.JSONDataFilter;
import org.mortbay.log.Log;
import org.mortbay.util.ajax.JSON;

public abstract class AbstractCometdServlet
extends GenericServlet {
    public static final String CLIENT_ATTR = "org.mortbay.cometd.client";
    public static final String TRANSPORT_ATTR = "org.mortbay.cometd.transport";
    public static final String MESSAGE_PARAM = "message";
    public static final String TUNNEL_INIT_PARAM = "tunnelInit";
    public static final String HTTP_CLIENT_ID = "BAYEUX_HTTP_CLIENT";
    public static final String BROWSER_ID = "BAYEUX_BROWSER";
    protected AbstractBayeux _bayeux;
    public static final int __DEFAULT_REFS_THRESHOLD = 0;
    protected int _refsThreshold = 0;
    private static Message[] __EMPTY_BATCH = new Message[0];

    public AbstractBayeux getBayeux() {
        return this._bayeux;
    }

    protected abstract AbstractBayeux newBayeux();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        Object object = AbstractCometdServlet.class;
        synchronized (AbstractCometdServlet.class) {
            this._bayeux = (AbstractBayeux)this.getServletContext().getAttribute("org.cometd.bayeux");
            if (this._bayeux == null) {
                this._bayeux = this.newBayeux();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = this._bayeux;
            synchronized (object) {
                boolean was_initialized = this._bayeux.isInitialized();
                this._bayeux.initialize(this.getServletContext());
                if (!was_initialized) {
                    String refsThreshold;
                    String requestAvailable;
                    String mfInterval;
                    String interval;
                    String commentedJSON;
                    String maxInterval;
                    String timeout;
                    String filters = this.getInitParameter("filters");
                    if (filters != null) {
                        try {
                            InputStream is = this.getServletContext().getResourceAsStream(filters);
                            if (is == null) {
                                throw new FileNotFoundException(filters);
                            }
                            Object[] objects = (Object[])JSON.parse((Reader)new InputStreamReader(this.getServletContext().getResourceAsStream(filters), "utf-8"));
                            for (int i = 0; objects != null && i < objects.length; ++i) {
                                Map filter_def = (Map)objects[i];
                                String fc = (String)filter_def.get("class");
                                if (fc != null) {
                                    Log.warn((String)(filters + " file uses deprecated \"class\" name. Use \"filter\" instead"));
                                } else {
                                    fc = (String)filter_def.get("filter");
                                }
                                Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(fc);
                                DataFilter filter = (DataFilter)c.newInstance();
                                if (filter instanceof JSONDataFilter) {
                                    ((JSONDataFilter)filter).init(filter_def.get("init"));
                                }
                                this._bayeux.getChannel((String)filter_def.get("channels"), true).addDataFilter(filter);
                            }
                        }
                        catch (Exception e) {
                            this.getServletContext().log("Could not parse: " + filters, (Throwable)e);
                            throw new ServletException((Throwable)e);
                        }
                    }
                    if ((timeout = this.getInitParameter("timeout")) != null) {
                        this._bayeux.setTimeout(Long.parseLong(timeout));
                    }
                    if ((maxInterval = this.getInitParameter("maxInterval")) != null) {
                        this._bayeux.setMaxInterval(Long.parseLong(maxInterval));
                    }
                    this._bayeux.setJSONCommented((commentedJSON = this.getInitParameter("JSONCommented")) != null && Boolean.parseBoolean(commentedJSON));
                    String l = this.getInitParameter("logLevel");
                    if (l != null && l.length() > 0) {
                        this._bayeux.setLogLevel(Integer.parseInt(l));
                    }
                    if ((interval = this.getInitParameter("interval")) != null) {
                        this._bayeux.setInterval(Long.parseLong(interval));
                    }
                    if ((mfInterval = this.getInitParameter("multiFrameInterval")) != null) {
                        this._bayeux.setMultiFrameInterval(Integer.parseInt(mfInterval));
                    }
                    this._bayeux.setRequestAvailable((requestAvailable = this.getInitParameter("requestAvailable")) != null && Boolean.parseBoolean(requestAvailable));
                    String async = this.getInitParameter("asyncDeliver");
                    if (async != null) {
                        this.getServletContext().log("asyncDeliver no longer supported");
                    }
                    if ((refsThreshold = this.getInitParameter("refsThreshold")) != null) {
                        this._refsThreshold = Integer.parseInt(refsThreshold);
                    }
                    this._bayeux.generateAdvice();
                    if (this._bayeux.isLogInfo()) {
                        this.getServletContext().log("timeout=" + timeout);
                        this.getServletContext().log("interval=" + interval);
                        this.getServletContext().log("maxInterval=" + maxInterval);
                        this.getServletContext().log("multiFrameInterval=" + mfInterval);
                        this.getServletContext().log("filters=" + filters);
                        this.getServletContext().log("refsThreshold=" + refsThreshold);
                    }
                }
            }
            this.getServletContext().setAttribute("org.cometd.bayeux", (Object)this._bayeux);
            return;
        }
    }

    protected abstract void service(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        if (this._bayeux.isRequestAvailable()) {
            this._bayeux.setCurrentRequest(request);
        }
        try {
            this.service(request, response);
        }
        finally {
            if (this._bayeux.isRequestAvailable()) {
                this._bayeux.setCurrentRequest(null);
            }
        }
    }

    protected String findBrowserId(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!BROWSER_ID.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected String setBrowserId(HttpServletRequest request, HttpServletResponse response) {
        String browser_id = Long.toHexString(request.getRemotePort()) + Long.toString(this._bayeux.getRandom(), 36) + Long.toString(System.currentTimeMillis(), 36) + Long.toString(request.getRemotePort(), 36);
        Cookie cookie = new Cookie(BROWSER_ID, browser_id);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        response.addCookie(cookie);
        return browser_id;
    }

    protected Message[] getMessages(HttpServletRequest request) throws IOException {
        String fodder = null;
        try {
            if (request.getContentType() != null && !request.getContentType().startsWith("application/x-www-form-urlencoded")) {
                return this._bayeux.parse(request.getReader());
            }
            String[] batches = request.getParameterValues(MESSAGE_PARAM);
            if (batches == null || batches.length == 0) {
                return __EMPTY_BATCH;
            }
            if (batches.length == 0) {
                fodder = batches[0];
                return this._bayeux.parse(fodder);
            }
            ArrayList<Message> messages = new ArrayList<Message>();
            for (int i = 0; i < batches.length; ++i) {
                if (batches[i] == null) continue;
                fodder = batches[i];
                this._bayeux.parseTo(fodder, messages);
            }
            return messages.toArray(new Message[messages.size()]);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error(fodder, e);
        }
    }
}

