/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre19Compat;
import org.apache.tomcat.util.compat.Jre21Compat;
import org.apache.tomcat.util.compat.Jre22Compat;
import org.apache.tomcat.util.res.StringManager;

public class JreCompat {
    private static final Log log = LogFactory.getLog(JreCompat.class);
    private static final StringManager sm = StringManager.getManager(JreCompat.class);
    private static final JreCompat instance;
    private static final boolean graalAvailable;
    private static final boolean jre19Available;
    private static final boolean jre21Available;
    private static final boolean jre22Available;
    private static final Field useCanonCachesField;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isGraalAvailable() {
        return graalAvailable;
    }

    public static boolean isJre19Available() {
        return jre19Available;
    }

    public static boolean isJre21Available() {
        return jre21Available;
    }

    public static boolean isJre22Available() {
        return jre22Available;
    }

    public Object getExecutor(Thread thread) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Object result = null;
        Object target = null;
        for (String fieldName : new String[]{"target", "runnable", "action"}) {
            try {
                Field targetField = thread.getClass().getDeclaredField(fieldName);
                targetField.setAccessible(true);
                target = targetField.get(thread);
                break;
            }
            catch (NoSuchFieldException nfe) {
            }
        }
        if (target != null && target.getClass().getCanonicalName() != null && (target.getClass().getCanonicalName().equals("org.apache.tomcat.util.threads.ThreadPoolExecutor.Worker") || target.getClass().getCanonicalName().equals("java.util.concurrent.ThreadPoolExecutor.Worker"))) {
            Field executorField = target.getClass().getDeclaredField("this$0");
            executorField.setAccessible(true);
            result = executorField.get(target);
        }
        return result;
    }

    public Object createVirtualThreadBuilder(String name) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noVirtualThreads"));
    }

    public void threadBuilderStart(Object threadBuilder, Runnable command) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noVirtualThreads"));
    }

    public <T> T callAs(Subject subject, final Callable<T> action) throws CompletionException {
        try {
            return Subject.doAs(subject, new PrivilegedExceptionAction<T>(){
                final /* synthetic */ JreCompat this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public T run() throws Exception {
                    return action.call();
                }
            });
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    public boolean isCanonCachesDisabled() {
        if (useCanonCachesField == null) {
            return false;
        }
        boolean result = false;
        try {
            result = (Boolean)useCanonCachesField.get(null) == false;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return result;
    }

    public boolean disableCanonCaches() {
        if (useCanonCachesField == null) {
            log.warn(sm.getString("jreCompat.useCanonCaches.none"));
            return false;
        }
        try {
            useCanonCachesField.set(null, Boolean.FALSE);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            log.warn(sm.getString("jreCompat.useCanonCaches.failed"), e);
            return false;
        }
        return true;
    }

    static {
        boolean result = false;
        try {
            Class<?> nativeImageClazz = Class.forName("org.graalvm.nativeimage.ImageInfo");
            result = Boolean.TRUE.equals(nativeImageClazz.getMethod("inImageCode", new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException nativeImageClazz) {
        }
        catch (IllegalArgumentException | ReflectiveOperationException nativeImageClazz) {
            // empty catch block
        }
        boolean bl = graalAvailable = result || System.getProperty("org.graalvm.nativeimage.imagecode") != null;
        if (Jre22Compat.isSupported()) {
            instance = new Jre22Compat();
            jre22Available = true;
            jre21Available = true;
            jre19Available = true;
        } else if (Jre21Compat.isSupported()) {
            instance = new Jre21Compat();
            jre22Available = false;
            jre21Available = true;
            jre19Available = true;
        } else if (Jre19Compat.isSupported()) {
            instance = new Jre19Compat();
            jre22Available = false;
            jre21Available = false;
            jre19Available = true;
        } else {
            instance = new JreCompat();
            jre22Available = false;
            jre21Available = false;
            jre19Available = false;
        }
        Field f1 = null;
        try {
            Class<?> clazz = Class.forName("java.io.FileSystem");
            f1 = clazz.getDeclaredField("useCanonCaches");
            f1.setAccessible(true);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | InaccessibleObjectException e) {
            log.debug(sm.getString("jreCompat.useCanonCaches.init"), e);
        }
        useCanonCachesField = f1;
    }
}

