/*
 * Decompiled with CFR 0.152.
 */
package org.monte.quicktimedemo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.QuickTimeReader;
import org.monte.media.quicktime.QuickTimeWriter;

public class Main {
    public static void main(String[] args) {
        System.out.println("QuickTimeDemo " + Main.class.getPackage().getImplementationVersion());
        System.out.println("This is a demo of the Monte Media library.");
        System.out.println("Copyright \u00a9 Werner Randelshofer. All Rights Reserved.");
        System.out.println("License: Creative Commons Attribution 3.0.");
        System.out.println();
        try {
            Main.test(new File("quicktimedemo-jpg.mov"), new Format(VideoFormatKeys.EncodingKey, "jpeg", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.QualityKey, Float.valueOf(1.0f)));
            Main.test(new File("quicktimedemo-jpg-q0.5.mov"), new Format(VideoFormatKeys.EncodingKey, "jpeg", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.QualityKey, Float.valueOf(0.5f)));
            Main.test(new File("quicktimedemo-png.mov"), new Format(VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DepthKey, 24));
            Main.test(new File("quicktimedemo-raw24.mov"), new Format(VideoFormatKeys.EncodingKey, "raw ", VideoFormatKeys.DepthKey, 24));
            Main.test(new File("quicktimedemo-raw8.mov"), new Format(VideoFormatKeys.EncodingKey, "raw ", VideoFormatKeys.DepthKey, 8));
            Main.test(new File("quicktimedemo-anim8.mov"), new Format(VideoFormatKeys.EncodingKey, "rle ", VideoFormatKeys.DepthKey, 8));
            Main.test(new File("quicktimedemo-tscc8.mov"), new Format(VideoFormatKeys.EncodingKey, "tscc", VideoFormatKeys.DepthKey, 8));
            Main.test(new File("quicktimedemo-tscc24.mov"), new Format(VideoFormatKeys.EncodingKey, "tscc", VideoFormatKeys.DepthKey, 24));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void test(File file, Format format) throws IOException {
        Main.testWriting(file, format);
        try {
            Main.testReading(file);
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testWriting(File file, Format format) throws IOException {
        System.out.println("Writing " + file);
        format = format.prepend(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.FrameRateKey, new Rational(30L, 1L), VideoFormatKeys.WidthKey, 320, VideoFormatKeys.HeightKey, 160});
        BufferedImage img = Main.createImage(format);
        Graphics2D g = img.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        QuickTimeWriter out = null;
        try {
            out = new QuickTimeWriter(file);
            out.addTrack(format);
            out.setVideoColorTable(0, img.getColorModel());
            Random rnd = new Random(0L);
            g.setBackground(Color.WHITE);
            g.clearRect(0, 0, img.getWidth(), img.getHeight());
            for (int i = 0; i < 100; ++i) {
                g.setColor(new Color(rnd.nextInt()));
                g.fillOval(rnd.nextInt(img.getWidth() - 30), rnd.nextInt(img.getHeight() - 30), 30, 30);
                out.write(0, img, 1L);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            g.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testReading(File file) throws IOException {
        System.out.println("Reading " + file);
        QuickTimeReader in = null;
        try {
            int track;
            in = new QuickTimeReader(file);
            for (track = 0; track < in.getTrackCount() && in.getFormat(track).get(VideoFormatKeys.MediaTypeKey) != FormatKeys.MediaType.VIDEO; ++track) {
            }
            BufferedImage img = null;
            while ((img = in.read(track, img)) != null) {
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static BufferedImage createImage(Format format) {
        BufferedImage img;
        int depth = format.get(VideoFormatKeys.DepthKey);
        int width = format.get(VideoFormatKeys.WidthKey);
        int height = format.get(VideoFormatKeys.HeightKey);
        Random rnd = new Random(0L);
        switch (depth) {
            default: {
                img = new BufferedImage(width, height, 1);
                break;
            }
            case 8: {
                byte[] red = new byte[256];
                byte[] green = new byte[256];
                byte[] blue = new byte[256];
                for (int i = 0; i < 255; ++i) {
                    red[i] = (byte)rnd.nextInt(256);
                    green[i] = (byte)rnd.nextInt(256);
                    blue[i] = (byte)rnd.nextInt(256);
                }
                rnd.setSeed(0L);
                IndexColorModel palette = new IndexColorModel(8, 256, red, green, blue);
                img = new BufferedImage(width, height, 13, palette);
                break;
            }
            case 4: {
                byte[] red = new byte[16];
                byte[] green = new byte[16];
                byte[] blue = new byte[16];
                for (int i = 0; i < 15; ++i) {
                    red[i] = (byte)rnd.nextInt(16);
                    green[i] = (byte)rnd.nextInt(16);
                    blue[i] = (byte)rnd.nextInt(16);
                }
                rnd.setSeed(0L);
                IndexColorModel palette = new IndexColorModel(4, 16, red, green, blue);
                img = new BufferedImage(width, height, 13, palette);
                break;
            }
        }
        return img;
    }
}

