/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.seq;

import java.awt.image.ColorModel;
import java.util.Vector;
import org.monte.media.image.BitmapImage;
import org.monte.media.seq.SEQAudioCommand;
import org.monte.media.seq.SEQMovieTrack;

public abstract class SEQFrame {
    protected ColorModel colorModel;
    protected byte[] data;
    private int operation;
    private int storageMethod;
    private long reltime;
    private int interleave;
    private int bits;
    protected static final int BadBitsOP_GeneralDelta = 65472;
    protected static final int BIT_LongData = 1;
    protected static final int BIT_XOR = 2;
    protected static final int BIT_OneInfoListForAllPlanes = 4;
    protected static final int BIT_RLC = 8;
    protected static final int BIT_Vertical = 16;
    protected static final int BIT_LongInfoOffsets = 32;
    protected static final int BadBitsOP_ByteVertical = 65527;
    private SEQAudioCommand[] audioCommands;

    public void addAudioCommand(SEQAudioCommand command) {
        if (this.audioCommands == null) {
            this.audioCommands = new SEQAudioCommand[1];
        } else {
            SEQAudioCommand[] old = this.audioCommands;
            this.audioCommands = new SEQAudioCommand[old.length + 1];
            System.arraycopy(old, 0, this.audioCommands, 0, old.length);
        }
        this.audioCommands[this.audioCommands.length - 1] = command;
    }

    public SEQAudioCommand[] getAudioCommands() {
        return this.audioCommands;
    }

    public void cleanUpAudioCommands() {
        if (this.audioCommands != null && this.audioCommands.length > 1) {
            Vector<SEQAudioCommand> v = new Vector<SEQAudioCommand>();
            v.addElement(this.audioCommands[0]);
            for (int i = 1; i < this.audioCommands.length; ++i) {
                int j;
                for (j = 0; j < i && (this.audioCommands[j].getChannelMask() & this.audioCommands[i].getChannelMask()) == 0; ++j) {
                }
                if (j != i) continue;
                v.addElement(this.audioCommands[i]);
            }
            this.audioCommands = new SEQAudioCommand[v.size()];
            v.copyInto(this.audioCommands);
        }
    }

    public void setColorModel(ColorModel cm) {
        this.colorModel = cm;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public void setStorageMethod(int storageMethod) {
        this.storageMethod = storageMethod;
    }

    public void setWidth(int w) {
    }

    public void setHeight(int h) {
    }

    public void setX(int x) {
    }

    public void setY(int y) {
    }

    public void setAbsTime(long abstime) {
    }

    public void setRelTime(long reltime) {
        this.reltime = reltime;
    }

    public void setInterleave(int interleave) {
        this.interleave = interleave;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public int getOperation() {
        return this.operation;
    }

    public int getStorageMethod() {
        return this.storageMethod;
    }

    public int getBits() {
        return this.bits;
    }

    public long getRelTime() {
        return this.reltime;
    }

    public int getInterleave() {
        return this.interleave;
    }

    public abstract void decode(BitmapImage var1, SEQMovieTrack var2);

    public int getTopBound(SEQMovieTrack track) {
        return 0;
    }

    public int getBottomBound(SEQMovieTrack track) {
        return track.getHeight() - 1;
    }

    public int getLeftBound(SEQMovieTrack track) {
        return 0;
    }

    public int getRightBound(SEQMovieTrack track) {
        return track.getWidth() - 1;
    }

    public boolean isBidirectional() {
        return true;
    }
}

