/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.monte.media.io.ImageInputStreamImpl2;

public class UncachedImageInputStream
extends ImageInputStreamImpl2 {
    private InputStream in;

    public UncachedImageInputStream(InputStream in) {
        this(in, ByteOrder.BIG_ENDIAN);
    }

    public UncachedImageInputStream(InputStream in, ByteOrder bo) {
        this.in = in;
        this.byteOrder = bo;
    }

    public int read() throws IOException {
        int b = this.in.read();
        if (b >= 0) {
            ++this.streamPos;
        }
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = this.in.read(b, off, len);
        if (count > 0) {
            this.streamPos += (long)count;
        }
        return count;
    }

    public void seek(long pos) throws IOException {
        this.checkClosed();
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        if (pos < this.streamPos) {
            throw new IndexOutOfBoundsException("pos < streamPos!");
        }
        this.bitOffset = 0;
        while (this.streamPos < pos) {
            long skipped = this.in.skip(pos - this.streamPos);
            if (skipped < 0L) {
                throw new EOFException("EOF reached while trying to seek to " + pos);
            }
            this.streamPos += skipped;
        }
    }
}

