/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.gui.plaf;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.monte.media.gui.border.BackdropBorder;
import org.monte.media.gui.plaf.ImageButtonListener;
import org.monte.media.gui.plaf.PlafConstants;

public class CustomButtonUI
extends BasicButtonUI
implements PlafConstants {
    private static final CustomButtonUI imageButtonUI = new CustomButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return new CustomButtonUI();
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
    }

    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new ImageButtonListener(b);
    }

    public void paint(Graphics g, JComponent c) {
        g.setColor(c.getBackground());
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
        ButtonModel m = ((AbstractButton)c).getModel();
        Border b = c.getBorder();
        if (b instanceof BackdropBorder) {
            ((BackdropBorder)b).getBackgroundBorder().paintBorder(c, g, 0, 0, c.getWidth(), c.getHeight());
        }
        super.paint(g, c);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), textRect.x, textRect.y + fm.getAscent());
        } else {
            g.setColor(b.getForeground().brighter());
            BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), textRect.x, textRect.y + fm.getAscent());
        }
    }
}

