/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.gui;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.accessibility.AccessibleText;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;

public class JLabelHyperlinkHandler {
    private JLabel label;
    private Handler handler = new Handler();
    private ArrayList<ActionListener> actionListeners = new ArrayList();

    public JLabelHyperlinkHandler() {
        this(null, null);
    }

    public JLabelHyperlinkHandler(JLabel label, ActionListener l) {
        this.setLabel(label);
        if (l != null) {
            this.addActionListener(l);
        }
    }

    public void setLabel(JLabel newValue) {
        if (this.label != null) {
            this.label.removeMouseListener(this.handler);
            this.label.removeMouseMotionListener(this.handler);
            this.label.setCursor(Cursor.getDefaultCursor());
        }
        this.label = newValue;
        if (this.label != null) {
            this.label.addMouseListener(this.handler);
            this.label.addMouseMotionListener(this.handler);
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void addActionListener(ActionListener l) {
        if (l != null) {
            this.actionListeners.add(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (l != null) {
            this.actionListeners.remove(l);
        }
    }

    private void fireActionPerformed(ActionEvent evt) {
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(evt);
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener {
        private Handler() {
        }

        public void mouseClicked(MouseEvent e) {
            Point point = e.getPoint();
            AccessibleText at = (AccessibleText)((Object)JLabelHyperlinkHandler.this.label.getAccessibleContext());
            int pos = at.getIndexAtPoint(point);
            AttributeSet as = at.getCharacterAttribute(pos);
            if (JLabelHyperlinkHandler.this.label.isEnabled() && as.getAttribute(HTML.Tag.A) != null) {
                JLabelHyperlinkHandler.this.label.setCursor(Cursor.getPredefinedCursor(12));
                SimpleAttributeSet attr = (SimpleAttributeSet)as.getAttribute(HTML.Tag.A);
                String href = (String)attr.getAttribute(HTML.Attribute.HREF);
                JLabelHyperlinkHandler.this.fireActionPerformed(new ActionEvent(JLabelHyperlinkHandler.this.label, 1001, href));
            } else {
                JLabelHyperlinkHandler.this.label.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            Point point = e.getPoint();
            AccessibleText at = (AccessibleText)((Object)JLabelHyperlinkHandler.this.label.getAccessibleContext());
            int pos = at.getIndexAtPoint(point);
            AttributeSet as = at.getCharacterAttribute(pos);
            if (JLabelHyperlinkHandler.this.label.isEnabled() && as.getAttribute(HTML.Tag.A) != null) {
                JLabelHyperlinkHandler.this.label.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                JLabelHyperlinkHandler.this.label.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

