/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.eightsvx;

import java.applet.AudioClip;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.monte.media.AbortException;
import org.monte.media.ParseException;
import org.monte.media.eightsvx.EightSVXAudioClip;
import org.monte.media.iff.IFFChunk;
import org.monte.media.iff.IFFParser;
import org.monte.media.iff.IFFVisitor;
import org.monte.media.iff.MC68000InputStream;

public class EightSVXDecoder
implements IFFVisitor {
    public static final int EIGHT_SVX_ID = IFFParser.stringToID("8SVX");
    public static final int VHDR_ID = IFFParser.stringToID("VHDR");
    public static final int NAME_ID = IFFParser.stringToID("NAME");
    public static final int COPYRIGHT_ID = IFFParser.stringToID("(c) ");
    public static final int ANNO_ID = IFFParser.stringToID("ANNO");
    public static final int AUTH_ID = IFFParser.stringToID("AUTH");
    public static final int CHAN_ID = IFFParser.stringToID("CHAN");
    public static final int BODY_ID = IFFParser.stringToID("BODY");
    private Vector samples_ = new Vector();
    private boolean within8SVXGroup_ = false;

    public EightSVXDecoder(InputStream in) throws IOException {
        try {
            IFFParser iff = new IFFParser();
            this.registerChunks(iff);
            iff.parse(in, this);
        }
        catch (ParseException e) {
            throw new IOException(e.toString());
        }
        catch (AbortException e) {
            throw new IOException(e.toString());
        }
        finally {
            in.close();
        }
    }

    public EightSVXDecoder() {
    }

    public Vector getSamples() {
        return this.samples_;
    }

    public void registerChunks(IFFParser iff) {
        iff.declareGroupChunk(EIGHT_SVX_ID, 1179603533);
        iff.declarePropertyChunk(EIGHT_SVX_ID, VHDR_ID);
        iff.declarePropertyChunk(EIGHT_SVX_ID, NAME_ID);
        iff.declarePropertyChunk(EIGHT_SVX_ID, COPYRIGHT_ID);
        iff.declareCollectionChunk(EIGHT_SVX_ID, ANNO_ID);
        iff.declarePropertyChunk(EIGHT_SVX_ID, AUTH_ID);
        iff.declarePropertyChunk(EIGHT_SVX_ID, CHAN_ID);
        iff.declareDataChunk(EIGHT_SVX_ID, BODY_ID);
    }

    public void enterGroup(IFFChunk group) {
        if (group.getType() == EIGHT_SVX_ID) {
            this.within8SVXGroup_ = true;
        }
    }

    public void leaveGroup(IFFChunk group) {
        if (group.getType() == EIGHT_SVX_ID) {
            this.within8SVXGroup_ = false;
        }
    }

    public void visitChunk(IFFChunk group, IFFChunk chunk) throws ParseException {
        if (this.within8SVXGroup_ && chunk.getID() == BODY_ID) {
            if (group.getPropertyChunk(VHDR_ID) == null) {
                throw new ParseException("Sorry: Without 8SVX.VHDR-Chunk no sound possible");
            }
            EightSVXAudioClip newSample = new EightSVXAudioClip();
            this.decodeVHDR(newSample, group.getPropertyChunk(VHDR_ID));
            this.decodeCHAN(newSample, group.getPropertyChunk(CHAN_ID));
            this.decodeNAME(newSample, group.getPropertyChunk(NAME_ID));
            this.decodeCOPYRIGHT(newSample, group.getPropertyChunk(COPYRIGHT_ID));
            this.decodeAUTH(newSample, group.getPropertyChunk(COPYRIGHT_ID));
            this.decodeANNO(newSample, group.getCollectionChunks(ANNO_ID));
            this.decodeBODY(newSample, chunk);
            this.addAudioClip(newSample);
        }
    }

    public void addAudioClip(AudioClip clip) {
        this.samples_.addElement(clip);
    }

    protected void decodeVHDR(EightSVXAudioClip sample, IFFChunk chunk) throws ParseException {
        try {
            if (chunk != null) {
                MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
                sample.setOneShotHiSamples(in.readULONG());
                sample.setRepeatHiSamples(in.readULONG());
                sample.setSamplesPerHiCycle(in.readULONG());
                sample.setSampleRate(in.readUWORD());
                sample.setCtOctave(in.readUBYTE());
                sample.setSCompression(in.readUBYTE());
                sample.setVolume(in.readLONG());
            }
        }
        catch (IOException e) {
            throw new ParseException("Error parsing 8SVX VHDR:" + e.getMessage());
        }
    }

    protected void decodeCHAN(EightSVXAudioClip sample, IFFChunk chunk) throws ParseException {
        if (chunk != null) {
            sample.setSampleType(chunk.getData()[3]);
        }
    }

    protected void decodeNAME(EightSVXAudioClip sample, IFFChunk chunk) throws ParseException {
        if (chunk != null) {
            sample.setName(new String(chunk.getData()));
        }
    }

    protected void decodeCOPYRIGHT(EightSVXAudioClip sample, IFFChunk chunk) throws ParseException {
        if (chunk != null) {
            sample.setCopyright(new String(chunk.getData()));
        }
    }

    protected void decodeAUTH(EightSVXAudioClip sample, IFFChunk chunk) throws ParseException {
        if (chunk != null) {
            sample.setAuthor(new String(chunk.getData()));
        }
    }

    protected void decodeANNO(EightSVXAudioClip sample, IFFChunk[] chunks) throws ParseException {
        if (chunks != null) {
            for (int i = 0; i < chunks.length; ++i) {
                IFFChunk chunk = chunks[i];
                sample.setRemark(sample.getRemark() + new String(chunk.getData()));
            }
        }
    }

    protected void decodeBODY(EightSVXAudioClip sample, IFFChunk chunk) throws ParseException {
        if (chunk != null) {
            byte[] data = chunk.getData();
            sample.set8SVXBody(data);
        }
    }
}

