/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.monte.media.Buffer;
import org.monte.media.Codec;
import org.monte.media.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodecChain
implements Codec {
    private Codec first;
    private Codec second;
    private Buffer tmpBuf;
    private int firstState;
    private int secondState;
    private long firstElapsed;
    private long secondElapsed;

    public CodecChain(Codec first, Codec second) {
        if (first == null || second == null) {
            throw new IllegalArgumentException("first and second must not be null");
        }
        this.first = first;
        this.second = second;
    }

    public static Codec createCodecChain(List<Codec> codecs) {
        return CodecChain.createCodecChain(codecs.toArray(new Codec[codecs.size()]));
    }

    public static Codec createCodecChain(Codec ... codecs) {
        ArrayList<Codec> clist = new ArrayList<Codec>();
        for (Codec c : codecs) {
            if (c == null) continue;
            clist.add(c);
        }
        if (clist.isEmpty()) {
            return null;
        }
        if (clist.size() == 1) {
            return codecs[0];
        }
        CodecChain cc = new CodecChain((Codec)clist.get(clist.size() - 2), (Codec)clist.get(clist.size() - 1));
        for (int i = clist.size() - 3; i >= 0; --i) {
            cc = new CodecChain((Codec)clist.get(i), cc);
        }
        return cc;
    }

    @Override
    public Format[] getInputFormats() {
        return this.first.getInputFormats();
    }

    @Override
    public Format[] getOutputFormats(Format input) {
        ArrayList<Format> secondOuts = new ArrayList<Format>();
        for (Format firstOut : this.first.getOutputFormats(input)) {
            secondOuts.addAll(Arrays.asList(this.second.getOutputFormats(firstOut)));
        }
        return secondOuts.toArray(new Format[secondOuts.size()]);
    }

    @Override
    public Format setInputFormat(Format input) {
        return this.second.setInputFormat(this.first.setInputFormat(input));
    }

    @Override
    public Format getInputFormat() {
        return this.first.getInputFormat();
    }

    @Override
    public Format setOutputFormat(Format output) {
        return this.second.setOutputFormat(output);
    }

    @Override
    public Format getOutputFormat() {
        return this.second.getOutputFormat();
    }

    @Override
    public int process(Buffer in, Buffer out) {
        if (this.tmpBuf == null) {
            this.tmpBuf = new Buffer();
        }
        if (2 == (this.secondState & 2)) {
            long start = System.currentTimeMillis();
            this.secondState = this.second.process(this.tmpBuf, out);
            this.secondElapsed += System.currentTimeMillis() - start;
            return this.secondState;
        }
        long start = System.currentTimeMillis();
        this.firstState = this.first.process(in, this.tmpBuf);
        this.firstElapsed += System.currentTimeMillis() - start;
        if (this.firstState == 1) {
            return this.firstState;
        }
        if (4 == (this.firstState & 4)) {
            return this.firstState;
        }
        start = System.currentTimeMillis();
        this.secondState = this.second.process(this.tmpBuf, out);
        this.secondElapsed += System.currentTimeMillis() - start;
        if (this.secondState == 1) {
            return this.secondState;
        }
        return this.secondState & 0xFFFFFFFD | this.firstState & 0xFFFFFFFB;
    }

    @Override
    public String getName() {
        return this.first.getName() + ", " + this.second.getName();
    }

    @Override
    public void reset() {
        this.first.reset();
        this.second.reset();
        this.tmpBuf = null;
    }

    public String toString() {
        return "CodecChain{" + this.first + "," + this.second + "}";
    }

    public long getElapsedTime() {
        return this.firstElapsed + this.secondElapsed;
    }

    public String reportElapsedTime() {
        if (this.second instanceof CodecChain) {
            return "{" + this.first.getName() + " " + this.firstElapsed + ((CodecChain)this.second).reportElapsedTime0() + "}";
        }
        return "{" + this.first.getName() + " " + this.firstElapsed + ", " + this.second.getName() + " " + this.secondElapsed + "}";
    }

    private String reportElapsedTime0() {
        if (this.second instanceof CodecChain) {
            return ", " + this.first.getName() + " " + this.firstElapsed + ((CodecChain)this.second).reportElapsedTime0();
        }
        return ", " + this.first.getName() + " " + this.firstElapsed + ", " + this.second.getName() + " " + this.secondElapsed;
    }
}

