/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import org.monte.media.anim.ANIMFrame;
import org.monte.media.anim.ANIMMovieTrack;
import org.monte.media.image.BitmapImage;

public class ANIMDeltaFrame
extends ANIMFrame {
    private int leftBound;
    private int topBound;
    private int rightBound;
    private int bottomBound;
    private static final int ENCODING_BYTE_VERTICAL = 5;
    private static final int ENCODING_VERTICAL_7_SHORT = 6;
    private static final int ENCODING_VERTICAL_7_LONG = 7;
    private static final int ENCODING_VERTICAL_8_SHORT = 8;
    private static final int ENCODING_VERTICAL_8_LONG = 9;
    private static final int ENCODING_J = 74;
    public static final int OP_Direct = 0;
    public static final int OP_XOR = 1;
    public static final int OP_LongDelta = 2;
    public static final int OP_ShortDelta = 3;
    public static final int OP_GeneralDelta = 4;
    public static final int OP_ByteVertical = 5;
    public static final int OP_StereoDelta = 6;
    public static final int OP_Vertical7 = 7;
    public static final int OP_Vertical8 = 8;
    public static final int OP_J = 74;
    private boolean isWarningPrinted = false;

    private int getEncoding() {
        switch (this.getOperation()) {
            case 0: {
                throw new InternalError("Key Frames not yet supported (Anim Op0)");
            }
            case 5: {
                if (this.getBits() != 2 && (this.getBits() & 0xFFF7) != 0) {
                    throw new InternalError("Unknown Bits for Anim Op5 in ANHD; Bits:" + this.getBits());
                }
                return 5;
            }
            case 7: {
                if ((this.getBits() & 1) == 0) {
                    return 6;
                }
                return 7;
            }
            case 8: {
                if ((this.getBits() & 1) == 0) {
                    return 8;
                }
                return 9;
            }
            case 74: {
                return 74;
            }
        }
        throw new InternalError("ANIM Op" + this.getOperation() + " not supported.");
    }

    public void decode(BitmapImage bitmap, ANIMMovieTrack track) {
        switch (this.getEncoding()) {
            case 5: {
                this.decodeByteVertical(bitmap, track);
                break;
            }
            case 6: {
                this.decodeVertical7Short(bitmap, track);
                break;
            }
            case 7: {
                this.decodeVertical7Long(bitmap, track);
                break;
            }
            case 8: {
                this.decodeVertical8Short(bitmap, track);
                break;
            }
            case 9: {
                this.decodeVertical8Long(bitmap, track);
                break;
            }
            case 74: {
                this.decodeJ(bitmap, track);
                break;
            }
            default: {
                throw new InternalError("Unsupported encoding." + this.getEncoding());
            }
        }
    }

    private void decodeByteVertical(BitmapImage bitmap, ANIMMovieTrack track) {
        int columns = 0;
        int iOp = 0;
        byte[] planeBytes = bitmap.getBitmap();
        int iPl = 0;
        int widthInBytes = bitmap.getBitplaneStride();
        int interleave = track.getNbPlanes() * widthInBytes;
        int opCode = 0;
        int opCount = 0;
        byte copyByte = 0;
        this.leftBound = widthInBytes;
        this.rightBound = 0;
        this.topBound = track.getHeight();
        this.bottomBound = 0;
        int height = track.getHeight();
        boolean isXOR = this.getBits() == 2;
        int n = track.getNbPlanes();
        for (int i = 0; i < n; ++i) {
            iOp = ((this.data[i * 4] & 0xFF) << 24) + ((this.data[i * 4 + 1] & 0xFF) << 16) + ((this.data[i * 4 + 2] & 0xFF) << 8) + (this.data[i * 4 + 3] & 0xFF);
            try {
                if (iOp <= 0) continue;
                for (columns = 0; columns < widthInBytes; ++columns) {
                    iPl = columns + i * widthInBytes;
                    if ((opCount = this.data[iOp++] & 0xFF) <= 0) continue;
                    if (columns < this.leftBound) {
                        this.leftBound = columns;
                    }
                    if (columns > this.rightBound) {
                        this.rightBound = columns;
                    }
                    if ((opCode = this.data[iOp]) <= 0) {
                        this.topBound = 0;
                    } else if (opCode < this.topBound) {
                        this.topBound = opCode;
                    }
                    if (isXOR) {
                        while (opCount > 0) {
                            if ((opCode = this.data[iOp++]) > 0) {
                                iPl += opCode * interleave;
                            } else if (opCode < 0) {
                                opCode &= 0x7F;
                                while (opCode-- > 0) {
                                    int n2 = iPl;
                                    planeBytes[n2] = (byte)(planeBytes[n2] ^ this.data[iOp++]);
                                    iPl += interleave;
                                }
                            } else {
                                if ((opCode = this.data[iOp++] & 0xFF) == 0) {
                                    return;
                                }
                                copyByte = this.data[iOp++];
                                while (opCode-- > 0) {
                                    int n3 = iPl;
                                    planeBytes[n3] = (byte)(planeBytes[n3] ^ copyByte);
                                    iPl += interleave;
                                }
                            }
                            --opCount;
                        }
                    } else {
                        while (opCount > 0) {
                            if ((opCode = this.data[iOp++]) > 0) {
                                iPl += opCode * interleave;
                            } else if (opCode < 0) {
                                opCode &= 0x7F;
                                while (opCode-- > 0) {
                                    planeBytes[iPl] = this.data[iOp++];
                                    iPl += interleave;
                                }
                            } else {
                                if ((opCode = this.data[iOp++] & 0xFF) == 0) {
                                    return;
                                }
                                copyByte = this.data[iOp++];
                                while (opCode-- > 0) {
                                    planeBytes[iPl] = copyByte;
                                    iPl += interleave;
                                }
                            }
                            --opCount;
                        }
                    }
                    if (opCode <= 0) {
                        int bottom = (iPl - (columns + i * widthInBytes)) / interleave;
                        if (bottom <= this.bottomBound) continue;
                        this.bottomBound = bottom;
                        continue;
                    }
                    if (height - opCode <= this.bottomBound) continue;
                    this.bottomBound = height - opCode;
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        if (this.leftBound <= this.rightBound) {
            this.leftBound *= 8;
            this.rightBound = this.rightBound * 8 + 8;
        }
    }

    private void decodeVertical8Short(BitmapImage bitmap, ANIMMovieTrack track) {
        int columns = 0;
        int iOp = 0;
        byte[] planeBytes = bitmap.getBitmap();
        int iPl = 0;
        int widthInBytes = bitmap.getBitplaneStride();
        int interleave = track.getNbPlanes() * widthInBytes;
        int opCode = 0;
        int opCount = 0;
        byte copyByte1 = 0;
        byte copyByte2 = 0;
        this.leftBound = widthInBytes;
        this.rightBound = 0;
        this.topBound = track.getHeight() - 1;
        this.bottomBound = 0;
        int height = track.getHeight() - 1;
        for (int i = 0; i < track.getNbPlanes(); ++i) {
            iOp = ((this.data[i * 4] & 0xFF) << 24) + ((this.data[i * 4 + 1] & 0xFF) << 16) + ((this.data[i * 4 + 2] & 0xFF) << 8) + (this.data[i * 4 + 3] & 0xFF);
            if (iOp <= 0) continue;
            for (columns = 0; columns < widthInBytes; columns += 2) {
                iPl = columns + i * widthInBytes;
                if ((opCount = (this.data[iOp++] & 0xFF) << 8 | this.data[iOp++] & 0xFF) <= 0) continue;
                if (columns < this.leftBound) {
                    this.leftBound = columns;
                }
                if (columns > this.rightBound) {
                    this.rightBound = columns;
                }
                if ((opCode = this.data[iOp] << 8 | this.data[iOp + 1] & 0xFF) <= 0) {
                    this.topBound = 0;
                } else if (opCode < this.topBound) {
                    this.topBound = opCode;
                }
                while (opCount > 0) {
                    if ((opCode = this.data[iOp++] << 8 | this.data[iOp++] & 0xFF) > 0) {
                        iPl += opCode * interleave;
                    } else if (opCode < 0) {
                        opCode &= Short.MAX_VALUE;
                        while (opCode-- > 0) {
                            planeBytes[iPl] = this.data[iOp++];
                            planeBytes[iPl + 1] = this.data[iOp++];
                            iPl += interleave;
                        }
                    } else {
                        if ((opCode = (this.data[iOp++] << 8 | this.data[iOp++] & 0xFF) & 0xFFFF) == 0) {
                            return;
                        }
                        copyByte1 = this.data[iOp++];
                        copyByte2 = this.data[iOp++];
                        while (opCode-- > 0) {
                            planeBytes[iPl] = copyByte1;
                            planeBytes[iPl + 1] = copyByte2;
                            iPl += interleave;
                        }
                    }
                    --opCount;
                }
                if (opCode <= 0) {
                    int bottom = (iPl - (columns + i * widthInBytes)) / interleave;
                    if (bottom <= this.bottomBound) continue;
                    this.bottomBound = bottom;
                    continue;
                }
                if (height - opCode <= this.bottomBound) continue;
                this.bottomBound = height - opCode;
            }
        }
        if (this.leftBound <= this.rightBound) {
            this.leftBound *= 8;
            this.rightBound = this.rightBound * 8 + 16;
        }
    }

    private void decodeVertical8Long(BitmapImage bitmap, ANIMMovieTrack track) {
        int columns = 0;
        int iOp = 0;
        byte[] planeBytes = bitmap.getBitmap();
        int iPl = 0;
        int widthInBytes = bitmap.getBitplaneStride();
        int interleave = track.getNbPlanes() * widthInBytes;
        int opCode = 0;
        int opCount = 0;
        byte copyByte1 = 0;
        byte copyByte2 = 0;
        byte copyByte3 = 0;
        byte copyByte4 = 0;
        this.leftBound = widthInBytes;
        this.rightBound = 0;
        this.topBound = track.getHeight() - 1;
        this.bottomBound = 0;
        int height = track.getHeight() - 1;
        for (int i = 0; i < track.getNbPlanes(); ++i) {
            iOp = ((this.data[i * 4] & 0xFF) << 24) + ((this.data[i * 4 + 1] & 0xFF) << 16) + ((this.data[i * 4 + 2] & 0xFF) << 8) + (this.data[i * 4 + 3] & 0xFF);
            if (iOp <= 0) continue;
            for (columns = 0; columns < widthInBytes; columns += 4) {
                iPl = columns + i * widthInBytes;
                if ((opCount = ((this.data[iOp++] & 0xFF) << 24) + ((this.data[iOp++] & 0xFF) << 16) + ((this.data[iOp++] & 0xFF) << 8) + (this.data[iOp++] & 0xFF)) <= 0) continue;
                if (columns < this.leftBound) {
                    this.leftBound = columns;
                }
                if (columns > this.rightBound) {
                    this.rightBound = columns;
                }
                if ((opCode = ((this.data[iOp] & 0xFF) << 24) + ((this.data[iOp + 1] & 0xFF) << 16) + ((this.data[iOp + 2] & 0xFF) << 8) + (this.data[iOp + 3] & 0xFF)) <= 0) {
                    this.topBound = 0;
                } else if (opCode < this.topBound) {
                    this.topBound = opCode;
                }
                while (opCount > 0) {
                    if ((opCode = ((this.data[iOp++] & 0xFF) << 24) + ((this.data[iOp++] & 0xFF) << 16) + ((this.data[iOp++] & 0xFF) << 8) + (this.data[iOp++] & 0xFF)) > 0) {
                        iPl += opCode * interleave;
                    } else if (opCode < 0) {
                        opCode &= Integer.MAX_VALUE;
                        while (opCode-- > 0) {
                            planeBytes[iPl] = this.data[iOp++];
                            planeBytes[iPl + 1] = this.data[iOp++];
                            planeBytes[iPl + 2] = this.data[iOp++];
                            planeBytes[iPl + 3] = this.data[iOp++];
                            iPl += interleave;
                        }
                    } else {
                        if ((opCode = ((this.data[iOp++] & 0xFF) << 24) + ((this.data[iOp++] & 0xFF) << 16) + ((this.data[iOp++] & 0xFF) << 8) + (this.data[iOp++] & 0xFF)) == 0) {
                            return;
                        }
                        copyByte1 = this.data[iOp++];
                        copyByte2 = this.data[iOp++];
                        copyByte3 = this.data[iOp++];
                        copyByte4 = this.data[iOp++];
                        while (opCode-- > 0) {
                            planeBytes[iPl] = copyByte1;
                            planeBytes[iPl + 1] = copyByte2;
                            planeBytes[iPl + 2] = copyByte3;
                            planeBytes[iPl + 3] = copyByte4;
                            iPl += interleave;
                        }
                    }
                    --opCount;
                }
                if (opCode <= 0) {
                    int bottom = (iPl - (columns + i * widthInBytes)) / interleave;
                    if (bottom <= this.bottomBound) continue;
                    this.bottomBound = bottom;
                    continue;
                }
                if (height - opCode <= this.bottomBound) continue;
                this.bottomBound = height - opCode;
            }
        }
        if (this.leftBound <= this.rightBound) {
            this.leftBound *= 8;
            this.rightBound = this.rightBound * 8 + 32;
        }
    }

    private void decodeVertical7Short(BitmapImage bitmap, ANIMMovieTrack track) {
        int columns = 0;
        int iOp = 0;
        int iData = 0;
        byte[] planeBytes = bitmap.getBitmap();
        int iPl = 0;
        int widthInBytes = bitmap.getBitplaneStride();
        int interleave = bitmap.getScanlineStride();
        int opCode = 0;
        int opCount = 0;
        byte copyByte1 = 0;
        byte copyByte2 = 0;
        this.leftBound = widthInBytes;
        this.rightBound = 0;
        this.topBound = track.getHeight() - 1;
        this.bottomBound = 0;
        int height = track.getHeight() - 1;
        for (int i = 0; i < track.getNbPlanes(); ++i) {
            iOp = ((this.data[i * 4] & 0xFF) << 24) + ((this.data[i * 4 + 1] & 0xFF) << 16) + ((this.data[i * 4 + 2] & 0xFF) << 8) + (this.data[i * 4 + 3] & 0xFF);
            iData = ((this.data[i * 4 + 32] & 0xFF) << 24) + ((this.data[i * 4 + 33] & 0xFF) << 16) + ((this.data[i * 4 + 34] & 0xFF) << 8) + (this.data[i * 4 + 35] & 0xFF);
            if (iOp <= 0) continue;
            for (columns = 0; columns < widthInBytes; columns += 2) {
                iPl = columns + i * widthInBytes;
                if ((opCount = this.data[iOp++] & 0xFF) <= 0) continue;
                if (columns < this.leftBound) {
                    this.leftBound = columns;
                }
                if (columns > this.rightBound) {
                    this.rightBound = columns;
                }
                if ((opCode = this.data[iOp]) <= 0) {
                    this.topBound = 0;
                } else if (opCode < this.topBound) {
                    this.topBound = opCode;
                }
                while (opCount > 0) {
                    if ((opCode = this.data[iOp++]) > 0) {
                        iPl += opCode * interleave;
                    } else if (opCode < 0) {
                        opCode &= 0x7F;
                        while (opCode-- > 0) {
                            planeBytes[iPl] = this.data[iData++];
                            planeBytes[iPl + 1] = this.data[iData++];
                            iPl += interleave;
                        }
                    } else {
                        if ((opCode = this.data[iOp++] & 0xFF) == 0) {
                            return;
                        }
                        copyByte1 = this.data[iData++];
                        copyByte2 = this.data[iData++];
                        while (opCode-- > 0) {
                            planeBytes[iPl] = copyByte1;
                            planeBytes[iPl + 1] = copyByte2;
                            iPl += interleave;
                        }
                    }
                    --opCount;
                }
                if (opCode <= 0) {
                    int bottom = (iPl - (columns + i * widthInBytes)) / interleave;
                    if (bottom <= this.bottomBound) continue;
                    this.bottomBound = bottom;
                    continue;
                }
                if (height - opCode <= this.bottomBound) continue;
                this.bottomBound = height - opCode;
            }
        }
        if (this.leftBound <= this.rightBound) {
            this.leftBound *= 8;
            this.rightBound = this.rightBound * 8 + 32;
        }
    }

    private void decodeVertical7Long(BitmapImage bitmap, ANIMMovieTrack track) {
        int columns = 0;
        int iOp = 0;
        int iData = 0;
        byte[] planeBytes = bitmap.getBitmap();
        int iPl = 0;
        int widthInBytes = bitmap.getBitplaneStride();
        int interleave = track.getNbPlanes() * widthInBytes;
        int opCode = 0;
        int opCount = 0;
        byte copyByte1 = 0;
        byte copyByte2 = 0;
        byte copyByte3 = 0;
        byte copyByte4 = 0;
        this.leftBound = widthInBytes;
        this.rightBound = 0;
        this.topBound = track.getHeight() - 1;
        this.bottomBound = 0;
        int height = track.getHeight() - 1;
        for (int i = 0; i < track.getNbPlanes(); ++i) {
            iOp = ((this.data[i * 4] & 0xFF) << 24) + ((this.data[i * 4 + 1] & 0xFF) << 16) + ((this.data[i * 4 + 2] & 0xFF) << 8) + (this.data[i * 4 + 3] & 0xFF);
            iData = ((this.data[i * 4 + 32] & 0xFF) << 24) + ((this.data[i * 4 + 33] & 0xFF) << 16) + ((this.data[i * 4 + 34] & 0xFF) << 8) + (this.data[i * 4 + 35] & 0xFF);
            if (iOp <= 0) continue;
            for (columns = 0; columns < widthInBytes; columns += 4) {
                try {
                    iPl = columns + i * widthInBytes;
                    opCount = this.data[iOp++] & 0xFF;
                    if (opCount <= 0) continue;
                    if (columns < this.leftBound) {
                        this.leftBound = columns;
                    }
                    if (columns > this.rightBound) {
                        this.rightBound = columns;
                    }
                    if ((opCode = this.data[iOp]) <= 0) {
                        this.topBound = 0;
                    } else if (opCode < this.topBound) {
                        this.topBound = opCode;
                    }
                    while (opCount > 0) {
                        if ((opCode = this.data[iOp++]) > 0) {
                            iPl += opCode * interleave;
                        } else if (opCode < 0) {
                            opCode &= 0x7F;
                            while (opCode-- > 0) {
                                planeBytes[iPl] = this.data[iData++];
                                planeBytes[iPl + 1] = this.data[iData++];
                                planeBytes[iPl + 2] = this.data[iData++];
                                planeBytes[iPl + 3] = this.data[iData++];
                                iPl += interleave;
                            }
                        } else {
                            if ((opCode = this.data[iOp++] & 0xFF) == 0) {
                                return;
                            }
                            copyByte1 = this.data[iData++];
                            copyByte2 = this.data[iData++];
                            copyByte3 = this.data[iData++];
                            copyByte4 = this.data[iData++];
                            while (opCode-- > 0) {
                                planeBytes[iPl] = copyByte1;
                                planeBytes[iPl + 1] = copyByte2;
                                planeBytes[iPl + 2] = copyByte3;
                                planeBytes[iPl + 3] = copyByte4;
                                iPl += interleave;
                            }
                        }
                        --opCount;
                    }
                    if (opCode <= 0) {
                        int bottom = (iPl - (columns + i * widthInBytes)) / interleave;
                        if (bottom <= this.bottomBound) continue;
                        this.bottomBound = bottom;
                        continue;
                    }
                    if (height - opCode <= this.bottomBound) continue;
                    this.bottomBound = height - opCode;
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    if (this.isWarningPrinted) continue;
                    e.printStackTrace();
                    this.isWarningPrinted = true;
                }
            }
        }
        if (this.leftBound <= this.rightBound) {
            this.leftBound *= 8;
            this.rightBound = this.rightBound * 8 + 64;
        }
    }

    private void decodeJ(BitmapImage bitmap, ANIMMovieTrack track) {
        block24: {
            int nbPlanes = track.getNbPlanes();
            int widthInBytes = bitmap.getBitplaneStride();
            this.leftBound = track.getWidth() - 1;
            this.rightBound = 0;
            this.topBound = track.getHeight() - 1;
            this.bottomBound = 0;
            int pos = 0;
            byte[] planeBytes = bitmap.getBitmap();
            try {
                block7: while (pos < this.data.length) {
                    int changeType = (this.data[pos++] & 0xFF) << 8 | this.data[pos++] & 0xFF;
                    switch (changeType) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            int uniFlag = (this.data[pos++] & 0xFF) << 8 | this.data[pos++] & 0xFF;
                            int ySize = (this.data[pos++] & 0xFF) << 8 | this.data[pos++] & 0xFF;
                            int numBlocks = (this.data[pos++] & 0xFF) << 8 | this.data[pos++] & 0xFF;
                            for (int b = 0; b < numBlocks; ++b) {
                                int dest;
                                int y;
                                int z;
                                int offset = (this.data[pos++] & 0xFF) << 8 | this.data[pos++] & 0xFF;
                                this.leftBound = Math.min(this.leftBound, offset % widthInBytes * 8);
                                this.rightBound = Math.max(this.rightBound, offset % widthInBytes * 8 + 8);
                                this.topBound = Math.min(this.topBound, offset / widthInBytes);
                                this.bottomBound = Math.max(this.bottomBound, offset / widthInBytes + ySize);
                                int realOffset = offset / widthInBytes * nbPlanes;
                                realOffset *= widthInBytes;
                                realOffset += offset % widthInBytes;
                                if (uniFlag == 1) {
                                    for (z = 0; z < nbPlanes; ++z) {
                                        for (y = 0; y < ySize; ++y) {
                                            int n = dest = z * widthInBytes * ySize + y * widthInBytes + realOffset;
                                            planeBytes[n] = (byte)(planeBytes[n] ^ this.data[pos++]);
                                        }
                                    }
                                } else {
                                    for (z = 0; z < nbPlanes; ++z) {
                                        for (y = 0; y < ySize; ++y) {
                                            dest = z * widthInBytes * ySize + y * widthInBytes + realOffset;
                                            planeBytes[dest] = this.data[pos++];
                                        }
                                    }
                                }
                                if (pos % 2 != 1) continue;
                                ++pos;
                            }
                            continue block7;
                        }
                        case 2: {
                            int uniFlag = (this.data[pos++] & 0xFF) << 8 | this.data[pos++] & 0xFF;
                            int ySize = (this.data[pos++] & 0xFF) << 8 | this.data[pos++] & 0xFF;
                            int xSize = (this.data[pos++] & 0xFF) << 8 | this.data[pos++] & 0xFF;
                            int numBlocks = (this.data[pos++] & 0xFF) << 8 | this.data[pos++] & 0xFF;
                            for (int b = 0; b < numBlocks; ++b) {
                                int dest;
                                int x;
                                int y;
                                int z;
                                int offset = (this.data[pos++] & 0xFF) << 8 | this.data[pos++] & 0xFF;
                                this.leftBound = Math.min(this.leftBound, offset % widthInBytes * 8);
                                this.rightBound = Math.max(this.rightBound, (offset % widthInBytes + xSize) * 8 + 8);
                                this.topBound = Math.min(this.topBound, offset / widthInBytes);
                                this.bottomBound = Math.max(this.bottomBound, offset / widthInBytes + ySize);
                                int realOffset = offset / widthInBytes * nbPlanes;
                                realOffset *= widthInBytes;
                                realOffset += offset % widthInBytes;
                                if (uniFlag == 1) {
                                    for (z = 0; z < nbPlanes; ++z) {
                                        for (y = 0; y < ySize; ++y) {
                                            for (x = 0; x < xSize; ++x) {
                                                int n = dest = z * widthInBytes * ySize + y * widthInBytes + realOffset + x;
                                                planeBytes[n] = (byte)(planeBytes[n] ^ this.data[pos++]);
                                            }
                                        }
                                    }
                                } else {
                                    for (z = 0; z < nbPlanes; ++z) {
                                        for (y = 0; y < ySize; ++y) {
                                            for (x = 0; x < xSize; ++x) {
                                                dest = z * widthInBytes * ySize + y * widthInBytes + realOffset + x;
                                                planeBytes[dest] = this.data[pos++];
                                            }
                                        }
                                    }
                                }
                                if (pos % 2 != 1) continue;
                                ++pos;
                            }
                            continue block7;
                        }
                        default: {
                            System.out.println("Unsupported changeType in 'J' delta frame:" + changeType);
                            break;
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (this.isWarningPrinted) break block24;
                e.printStackTrace();
                this.isWarningPrinted = true;
            }
        }
    }

    public int getTopBound(ANIMMovieTrack track) {
        return this.topBound;
    }

    public int getBottomBound(ANIMMovieTrack track) {
        return this.bottomBound;
    }

    public int getLeftBound(ANIMMovieTrack track) {
        return this.leftBound;
    }

    public int getRightBound(ANIMMovieTrack track) {
        return this.rightBound;
    }

    public boolean isBidirectional() {
        switch (this.getOperation()) {
            case 0: {
                return true;
            }
            case 5: {
                if (this.getBits() != 2) break;
                return true;
            }
            case 74: {
                return true;
            }
        }
        return false;
    }
}

