/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.io.File;
import java.util.ArrayList;
import org.monte.media.Codec;
import org.monte.media.DefaultRegistry;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.MovieReader;
import org.monte.media.MovieWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Registry {
    private static Registry instance;

    public static Registry getInstance() {
        if (instance == null) {
            instance = new DefaultRegistry();
            instance.init();
        }
        return instance;
    }

    protected abstract void init();

    public abstract void putCodec(Format var1, Format var2, String var3);

    public final String[] getDecoderClasses(Format format) {
        return this.getCodecClasses(format, null);
    }

    public final String[] getEncoderClasses(Format format) {
        return this.getCodecClasses(null, format);
    }

    public abstract String[] getCodecClasses(Format var1, Format var2);

    public final Codec[] getDecoders(Format inputFormat) {
        return this.getCodecs(inputFormat, null);
    }

    public Codec getDecoder(Format inputFormat) {
        return this.getCodec(inputFormat, null);
    }

    public final Codec[] getEncoders(Format outputFormat) {
        return this.getCodecs(null, outputFormat);
    }

    public Codec getEncoder(Format outputFormat) {
        return this.getCodec(null, outputFormat);
    }

    public Codec[] getCodecs(Format inputFormat, Format outputFormat) {
        String[] clazz = this.getCodecClasses(inputFormat, outputFormat);
        ArrayList<Codec> codecs = new ArrayList<Codec>(clazz.length);
        for (int i = 0; i < clazz.length; ++i) {
            try {
                codecs.add((Codec)Class.forName(clazz[i]).newInstance());
                continue;
            }
            catch (Exception ex) {
                System.err.println("Monte Registry. Codec class not found: " + clazz[i]);
                this.unregisterCodec(clazz[i]);
            }
        }
        return codecs.toArray(new Codec[codecs.size()]);
    }

    public Codec getCodec(Format inputFormat, Format outputFormat) {
        String[] clazz = this.getCodecClasses(inputFormat, outputFormat);
        for (int i = 0; i < clazz.length; ++i) {
            try {
                Codec codec = (Codec)Class.forName(clazz[i]).newInstance();
                codec.setInputFormat(inputFormat);
                if (outputFormat != null) {
                    codec.setOutputFormat(outputFormat);
                }
                return codec;
            }
            catch (Exception ex) {
                System.err.println("Monte Registry. Codec class not found: " + clazz[i]);
                this.unregisterCodec(clazz[i]);
                continue;
            }
        }
        return null;
    }

    public abstract void putReader(Format var1, String var2);

    public abstract void putWriter(Format var1, String var2);

    public abstract String[] getReaderClasses(Format var1);

    public abstract String[] getWriterClasses(Format var1);

    public MovieReader getReader(Format fileFormat, File file) {
        String[] clazz = this.getReaderClasses(fileFormat);
        for (int i = 0; i < clazz.length; ++i) {
            try {
                return (MovieReader)Class.forName(clazz[i]).getConstructor(File.class).newInstance(file);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
        }
        return null;
    }

    public MovieWriter getWriter(File file) {
        Format format = this.getFileFormat(file);
        return format == null ? null : this.getWriter(format, file);
    }

    public MovieWriter getWriter(Format fileFormat, File file) {
        String[] clazz = this.getWriterClasses(fileFormat);
        for (int i = 0; i < clazz.length; ++i) {
            try {
                return (MovieWriter)Class.forName(clazz[i]).getConstructor(File.class).newInstance(file);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
        }
        return null;
    }

    public MovieReader getReader(File file) {
        Format format = this.getFileFormat(file);
        return format == null ? null : this.getReader(format, file);
    }

    public abstract void putFileFormat(String var1, Format var2);

    public abstract Format getFileFormat(File var1);

    public abstract Format[] getReaderFormats();

    public abstract Format[] getWriterFormats();

    public abstract Format[] getFileFormats();

    public abstract String getExtension(Format var1);

    public ArrayList<Format> suggestOutputFormats(Format inputMediaFormat, Format outputFileFormat) {
        ArrayList<Format> formats = new ArrayList<Format>();
        Format matchFormat = new Format(new Object[]{FormatKeys.MimeTypeKey, outputFileFormat.get(FormatKeys.MimeTypeKey), FormatKeys.MediaTypeKey, inputMediaFormat.get(FormatKeys.MediaTypeKey)});
        Codec[] codecs = this.getEncoders(matchFormat);
        int matchingCount = 0;
        for (Codec c : codecs) {
            for (Format mf : c.getOutputFormats(null)) {
                if (!mf.matches(matchFormat)) continue;
                if (inputMediaFormat.matchesWithout(mf, FormatKeys.MimeTypeKey)) {
                    formats.add(0, mf.append(inputMediaFormat));
                    ++matchingCount;
                    continue;
                }
                if (inputMediaFormat.matchesWithout(mf, FormatKeys.MimeTypeKey, FormatKeys.EncodingKey)) {
                    formats.add(matchingCount, mf.append(inputMediaFormat));
                    continue;
                }
                formats.add(mf.append(inputMediaFormat));
            }
        }
        block2: for (int i = formats.size() - 1; i >= 0; --i) {
            Format fi = formats.get(i);
            for (int j = i - 1; j >= 0; --j) {
                Format fj = formats.get(j);
                if (!fi.matches(fj)) continue;
                formats.remove(i);
                continue block2;
            }
        }
        return formats;
    }

    public abstract void unregisterCodec(String var1);
}

