/*
 * Decompiled with CFR 0.152.
 */
package org.monte.iodemo;

import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import org.monte.media.Buffer;
import org.monte.media.Codec;
import org.monte.media.Format;
import org.monte.media.FormatFormatter;
import org.monte.media.FormatKeys;
import org.monte.media.MovieReader;
import org.monte.media.MovieWriter;
import org.monte.media.Registry;
import org.monte.media.converter.AdjustTimeCodec;
import org.monte.media.converter.CodecChain;
import org.monte.media.converter.TrimTimeCodec;
import org.monte.media.math.Rational;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimDemoMain {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File outfile = null;
        ArrayList<File> infiles = new ArrayList<File>();
        Rational start = null;
        Rational end = null;
        String startString = null;
        String durationString = null;
        try {
            int arg = 32;
            block21: for (int i = 0; i < args.length; ++i) {
                if (args[i].length() > 1 && args[i].charAt(0) == '-') {
                    arg = args[i].charAt(1);
                    if (args[i].matches("-i|-o|-ss|-t")) continue;
                    throw new IllegalArgumentException("error: illegal option: " + args[i]);
                }
                switch (arg) {
                    case 111: {
                        if (outfile != null) {
                            throw new IllegalArgumentException("error: only one outputfile allowed");
                        }
                        outfile = new File(args[i]);
                        continue block21;
                    }
                    case 105: {
                        infiles.add(new File(args[i]));
                        continue block21;
                    }
                    case 115: {
                        startString = args[i];
                        continue block21;
                    }
                    case 116: {
                        durationString = args[i];
                        continue block21;
                    }
                    default: {
                        throw new IllegalArgumentException("error: illegal option: " + args[i]);
                    }
                }
            }
            if (outfile == null) {
                if (infiles.isEmpty()) {
                    throw new IllegalArgumentException("error: no inputfiles specified");
                }
                TrimDemoMain.info(infiles);
                return;
            }
            for (File f : infiles) {
                if (f.exists()) continue;
                throw new IllegalArgumentException("error: inputfile does not exist: " + f);
            }
            MovieReader[] r = new MovieReader[1];
            try {
                start = TrimDemoMain.parseTime(startString, infiles, r);
                Rational duration = TrimDemoMain.parseTime(durationString, infiles, r);
                if (duration != null) {
                    end = start == null ? duration : start.add(duration);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (r[0] != null) {
                    try {
                        r[0].close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (start != null || end != null) {
                System.out.println("Trimming input files at seconds. start:" + (start == null ? "start of movie" : start.toDescriptiveString()) + ", end:" + (end == null ? "end of movie" : end.toDescriptiveString()));
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.err.println("usage: java -jar TrimDemo.jar [-o outputfile] [-i inputfile ...] [-ss startTime] [-t duration]");
            System.err.println("       -o Output file. Filename. e.g. movie.avi");
            System.err.println("       -i Input file. More than one can be specified. e.g. movie1.avi movie2.avi");
            System.err.println("       -ss Start time. Double, rational, or hh:mm:ss.frame. e.g. 1.5 or 3/2 or 00:00:01.15");
            System.err.println("       -t Duration. Double, rational, or hh:mm:ss.frame");
            String version = TrimDemoMain.class.getPackage().getImplementationVersion();
            System.err.println("TrimDemo " + (version == null ? "" : version + " ") + "(c) Werner Randelshofer");
            System.exit(10);
        }
        try {
            TrimDemoMain.concat(outfile, infiles, start, end);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void info(ArrayList<File> infiles) {
        for (File f : infiles) {
            System.out.println("Movie: " + f);
            if (!f.exists()) {
                System.out.println("  File does not exist.");
                continue;
            }
            MovieReader in = Registry.getInstance().getReader(f);
            try {
                TrimDemoMain.info(in);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            System.out.println();
        }
    }

    private static void info(MovieWriter w) throws IOException {
        System.out.println("  Format: " + FormatFormatter.toString(w.getFileFormat()));
        for (int t = 0; t < w.getTrackCount(); ++t) {
            System.out.println("  Track " + t);
            System.out.println("    Format: " + FormatFormatter.toString(w.getFormat(t)));
            System.out.println("    Duration: " + w.getDuration(t).toDescriptiveString() + " seconds");
        }
    }

    private static void info(MovieReader in) throws IOException {
        System.out.println("  Format: " + FormatFormatter.toString(in.getFileFormat()));
        System.out.println("  Duration: " + in.getDuration().toDescriptiveString() + " seconds");
        for (int t = 0; t < in.getTrackCount(); ++t) {
            System.out.println("  Track " + t);
            System.out.println("    Format: " + FormatFormatter.toString(in.getFormat(t)));
            System.out.println("    Duration: " + in.getDuration(t).toDescriptiveString() + " seconds");
            System.out.println("    Chunk Count: " + in.getChunkCount(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void concat(File outfile, ArrayList<File> infiles, Rational startTime, Rational endTime) throws IOException {
        MovieWriter out = Registry.getInstance().getWriter(outfile);
        if (out == null) {
            throw new IOException("output file format not supported for: " + outfile);
        }
        try {
            int t;
            int[][] matchingT = new int[infiles.size()][0];
            int imax = infiles.size();
            for (int i = 0; i < imax; ++i) {
                File infile = infiles.get(i);
                MovieReader in = Registry.getInstance().getReader(infile);
                if (in == null) {
                    throw new IOException("input file format not supported for: " + infile);
                }
                System.out.println(infile);
                TrimDemoMain.info(in);
                try {
                    matchingT[i] = new int[in.getTrackCount()];
                    int jmax = in.getTrackCount();
                    for (t = 0; t < jmax; ++t) {
                        matchingT[i][t] = -1;
                        int nOutputTracks = out.getTrackCount();
                        for (int outputTrack = 0; outputTrack < nOutputTracks; ++outputTrack) {
                            if (!in.getFormat(t).matches(out.getFormat(outputTrack))) continue;
                            for (int tt = 0; tt < t; ++tt) {
                                if (matchingT[i][tt] != outputTrack) continue;
                            }
                            matchingT[i][t] = outputTrack;
                            break;
                        }
                        if (matchingT[i][t] != -1) continue;
                        matchingT[i][t] = out.getTrackCount();
                        out.addTrack(in.getFormat(t));
                    }
                    continue;
                }
                finally {
                    in.close();
                }
            }
            int trackCount = out.getTrackCount();
            Codec[] ensureFirstFrameIsKeyframe = new Codec[trackCount];
            Codec[] passThrough = new Codec[trackCount];
            AdjustTimeCodec[] adjustTime = new AdjustTimeCodec[trackCount];
            for (t = 0; t < ensureFirstFrameIsKeyframe.length; ++t) {
                Codec decode = Registry.getInstance().getDecoder(out.getFormat(t));
                decode.setOutputFormat(decode.getOutputFormats(out.getFormat(t))[0]);
                Codec encode = Registry.getInstance().getCodec(decode.getOutputFormat(), out.getFormat(t));
                adjustTime[t] = new AdjustTimeCodec();
                TrimTimeCodec trimTime = new TrimTimeCodec();
                trimTime.setStartTime(startTime);
                trimTime.setEndTime(endTime);
                ensureFirstFrameIsKeyframe[t] = CodecChain.createCodecChain(adjustTime[t], decode, trimTime, encode);
                passThrough[t] = CodecChain.createCodecChain(adjustTime[t], trimTime);
            }
            Buffer inBuf = new Buffer();
            Buffer outBuf = new Buffer();
            int tracksNeeded = (1 << trackCount) - 1;
            int tracksDone = 0;
            int imax2 = infiles.size();
            block14: for (int i = 0; i < imax2; ++i) {
                int outTrack;
                int t2;
                File infile = infiles.get(i);
                MovieReader in = Registry.getInstance().getReader(infile);
                if (in == null) {
                    throw new IOException("input file format not supported for: " + infile);
                }
                if (i == 0 && startTime != null) {
                    in.setMovieReadTime(startTime);
                    for (t2 = 0; t2 < in.getTrackCount(); ++t2) {
                        outTrack = matchingT[i][t2];
                        adjustTime[outTrack].setMediaTime(in.getReadTime(t2));
                    }
                }
                try {
                    t2 = in.nextTrack();
                    while (t2 != -1) {
                        outTrack = matchingT[i][t2];
                        in.read(t2, inBuf);
                        int state = out.isEmpty(outTrack) ? ensureFirstFrameIsKeyframe[outTrack].process(inBuf, outBuf) : passThrough[outTrack].process(inBuf, outBuf);
                        if (endTime != null && outBuf.timeStamp.compareTo(endTime) > 0 && (tracksDone |= 1 << outTrack) == tracksNeeded) {
                            continue block14;
                        }
                        out.write(outTrack, outBuf);
                        t2 = in.nextTrack();
                    }
                    continue;
                }
                finally {
                    in.close();
                }
            }
            System.out.println(outfile);
            TrimDemoMain.info(out);
        }
        finally {
            out.close();
        }
    }

    private static Rational parseTime(String str, ArrayList<File> infiles, MovieReader[] r) throws IOException {
        block11: {
            if (str != null) {
                try {
                    return Rational.valueOf(str);
                }
                catch (NumberFormatException e) {
                    int t;
                    if (r[0] == null && !infiles.isEmpty()) {
                        r[0] = Registry.getInstance().getReader(infiles.get(0));
                    }
                    if (r[0] == null || (t = r[0].findTrack(0, new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO}))) == -1) break block11;
                    Format f = r[0].getFormat(t);
                    Rational frameRate = f.get(FormatKeys.FrameRateKey);
                    long seconds = 0L;
                    long frame = 0L;
                    StreamTokenizer tt = new StreamTokenizer(new StringReader(str));
                    tt.resetSyntax();
                    tt.wordChars(48, 57);
                    if (tt.nextToken() != -3) {
                        throw new NumberFormatException("hh:mm:ss.frame, hours missing: " + str);
                    }
                    seconds += Long.valueOf(tt.sval) * 3600L;
                    if (tt.nextToken() != 58) {
                        throw new NumberFormatException("hh:mm:ss.frame, 1st ':' missing: " + str);
                    }
                    if (tt.nextToken() != -3) {
                        throw new NumberFormatException("hh:mm:ss.frame, minutes missing: " + str);
                    }
                    seconds += Long.valueOf(tt.sval) * 60L;
                    if (tt.nextToken() != 58) {
                        throw new NumberFormatException("hh:mm:ss.frame, 2nd ':' missing: " + str);
                    }
                    if (tt.nextToken() != -3) {
                        throw new NumberFormatException("hh:mm:ss, seconds missing: " + str);
                    }
                    seconds += Long.valueOf(tt.sval).longValue();
                    if (tt.nextToken() == 46) {
                        if (tt.nextToken() != -3) {
                            throw new NumberFormatException("hh:mm:ss.frame, frames missing: " + str);
                        }
                        frame += Long.valueOf(tt.sval).longValue();
                    }
                    return new Rational(seconds).add(new Rational(frame).divide(frameRate));
                }
            }
        }
        return null;
    }
}

