/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.stitch.server.services.mongodb.remote;

import com.mongodb.MongoNamespace;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteCountOptions;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteDeleteResult;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteInsertManyResult;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteInsertOneResult;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteUpdateOptions;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteUpdateResult;
import com.mongodb.stitch.server.services.mongodb.remote.RemoteAggregateIterable;
import com.mongodb.stitch.server.services.mongodb.remote.RemoteFindIterable;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public interface RemoteMongoCollection<DocumentT> {
    public MongoNamespace getNamespace();

    public Class<DocumentT> getDocumentClass();

    public CodecRegistry getCodecRegistry();

    public <NewDocumentT> RemoteMongoCollection<NewDocumentT> withDocumentClass(Class<NewDocumentT> var1);

    public RemoteMongoCollection<DocumentT> withCodecRegistry(CodecRegistry var1);

    public long count();

    public long count(Bson var1);

    public long count(Bson var1, RemoteCountOptions var2);

    public RemoteFindIterable<DocumentT> find();

    public <ResultT> RemoteFindIterable<ResultT> find(Class<ResultT> var1);

    public RemoteFindIterable<DocumentT> find(Bson var1);

    public <ResultT> RemoteFindIterable<ResultT> find(Bson var1, Class<ResultT> var2);

    public RemoteAggregateIterable<DocumentT> aggregate(List<? extends Bson> var1);

    public <ResultT> RemoteAggregateIterable<ResultT> aggregate(List<? extends Bson> var1, Class<ResultT> var2);

    public RemoteInsertOneResult insertOne(DocumentT var1);

    public RemoteInsertManyResult insertMany(List<? extends DocumentT> var1);

    public RemoteDeleteResult deleteOne(Bson var1);

    public RemoteDeleteResult deleteMany(Bson var1);

    public RemoteUpdateResult updateOne(Bson var1, Bson var2);

    public RemoteUpdateResult updateOne(Bson var1, Bson var2, RemoteUpdateOptions var3);

    public RemoteUpdateResult updateMany(Bson var1, Bson var2);

    public RemoteUpdateResult updateMany(Bson var1, Bson var2, RemoteUpdateOptions var3);
}

