/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.stitch.android.services.mongodb.remote.internal;

import com.google.android.gms.tasks.Task;
import com.mongodb.MongoNamespace;
import com.mongodb.stitch.android.core.internal.common.TaskDispatcher;
import com.mongodb.stitch.android.services.mongodb.remote.RemoteAggregateIterable;
import com.mongodb.stitch.android.services.mongodb.remote.RemoteFindIterable;
import com.mongodb.stitch.android.services.mongodb.remote.RemoteMongoCollection;
import com.mongodb.stitch.android.services.mongodb.remote.internal.RemoteAggregateIterableImpl;
import com.mongodb.stitch.android.services.mongodb.remote.internal.RemoteFindIterableImpl;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteCountOptions;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteDeleteResult;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteInsertManyResult;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteInsertOneResult;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteUpdateOptions;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteUpdateResult;
import com.mongodb.stitch.core.services.mongodb.remote.internal.CoreRemoteMongoCollection;
import java.util.List;
import java.util.concurrent.Callable;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class RemoteMongoCollectionImpl<DocumentT>
implements RemoteMongoCollection<DocumentT> {
    private final CoreRemoteMongoCollection<DocumentT> proxy;
    private final TaskDispatcher dispatcher;

    RemoteMongoCollectionImpl(CoreRemoteMongoCollection<DocumentT> coll, TaskDispatcher dispatcher) {
        this.proxy = coll;
        this.dispatcher = dispatcher;
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.proxy.getNamespace();
    }

    @Override
    public Class<DocumentT> getDocumentClass() {
        return this.proxy.getDocumentClass();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.proxy.getCodecRegistry();
    }

    @Override
    public <NewDocumentT> RemoteMongoCollection<NewDocumentT> withDocumentClass(Class<NewDocumentT> clazz) {
        return new RemoteMongoCollectionImpl<DocumentT>(this.proxy.withDocumentClass(clazz), this.dispatcher);
    }

    @Override
    public RemoteMongoCollection<DocumentT> withCodecRegistry(CodecRegistry codecRegistry) {
        return new RemoteMongoCollectionImpl<DocumentT>(this.proxy.withCodecRegistry(codecRegistry), this.dispatcher);
    }

    @Override
    public Task<Long> count() {
        return this.dispatcher.dispatchTask((Callable)new Callable<Long>(){

            @Override
            public Long call() {
                return RemoteMongoCollectionImpl.this.proxy.count();
            }
        });
    }

    @Override
    public Task<Long> count(final Bson filter) {
        return this.dispatcher.dispatchTask((Callable)new Callable<Long>(){

            @Override
            public Long call() {
                return RemoteMongoCollectionImpl.this.proxy.count(filter);
            }
        });
    }

    @Override
    public Task<Long> count(final Bson filter, final RemoteCountOptions options) {
        return this.dispatcher.dispatchTask((Callable)new Callable<Long>(){

            @Override
            public Long call() {
                return RemoteMongoCollectionImpl.this.proxy.count(filter, options);
            }
        });
    }

    @Override
    public RemoteFindIterable<DocumentT> find() {
        return new RemoteFindIterableImpl(this.proxy.find(), this.dispatcher);
    }

    @Override
    public <ResultT> RemoteFindIterable<ResultT> find(Class<ResultT> resultClass) {
        return new RemoteFindIterableImpl(this.proxy.find(resultClass), this.dispatcher);
    }

    @Override
    public RemoteFindIterable<DocumentT> find(Bson filter) {
        return new RemoteFindIterableImpl(this.proxy.find(filter), this.dispatcher);
    }

    @Override
    public <ResultT> RemoteFindIterable<ResultT> find(Bson filter, Class<ResultT> resultClass) {
        return new RemoteFindIterableImpl(this.proxy.find(filter, resultClass), this.dispatcher);
    }

    @Override
    public RemoteAggregateIterable<DocumentT> aggregate(List<? extends Bson> pipeline) {
        return new RemoteAggregateIterableImpl(this.proxy.aggregate(pipeline), this.dispatcher);
    }

    @Override
    public <ResultT> RemoteAggregateIterable<ResultT> aggregate(List<? extends Bson> pipeline, Class<ResultT> resultClass) {
        return new RemoteAggregateIterableImpl(this.proxy.aggregate(pipeline, resultClass), this.dispatcher);
    }

    @Override
    public Task<RemoteInsertOneResult> insertOne(final DocumentT document) {
        return this.dispatcher.dispatchTask((Callable)new Callable<RemoteInsertOneResult>(){

            @Override
            public RemoteInsertOneResult call() {
                return RemoteMongoCollectionImpl.this.proxy.insertOne(document);
            }
        });
    }

    @Override
    public Task<RemoteInsertManyResult> insertMany(final List<? extends DocumentT> documents) {
        return this.dispatcher.dispatchTask((Callable)new Callable<RemoteInsertManyResult>(){

            @Override
            public RemoteInsertManyResult call() {
                return RemoteMongoCollectionImpl.this.proxy.insertMany(documents);
            }
        });
    }

    @Override
    public Task<RemoteDeleteResult> deleteOne(final Bson filter) {
        return this.dispatcher.dispatchTask((Callable)new Callable<RemoteDeleteResult>(){

            @Override
            public RemoteDeleteResult call() {
                return RemoteMongoCollectionImpl.this.proxy.deleteOne(filter);
            }
        });
    }

    @Override
    public Task<RemoteDeleteResult> deleteMany(final Bson filter) {
        return this.dispatcher.dispatchTask((Callable)new Callable<RemoteDeleteResult>(){

            @Override
            public RemoteDeleteResult call() {
                return RemoteMongoCollectionImpl.this.proxy.deleteMany(filter);
            }
        });
    }

    @Override
    public Task<RemoteUpdateResult> updateOne(final Bson filter, final Bson update) {
        return this.dispatcher.dispatchTask((Callable)new Callable<RemoteUpdateResult>(){

            @Override
            public RemoteUpdateResult call() {
                return RemoteMongoCollectionImpl.this.proxy.updateOne(filter, update);
            }
        });
    }

    @Override
    public Task<RemoteUpdateResult> updateOne(final Bson filter, final Bson update, final RemoteUpdateOptions updateOptions) {
        return this.dispatcher.dispatchTask((Callable)new Callable<RemoteUpdateResult>(){

            @Override
            public RemoteUpdateResult call() {
                return RemoteMongoCollectionImpl.this.proxy.updateOne(filter, update, updateOptions);
            }
        });
    }

    @Override
    public Task<RemoteUpdateResult> updateMany(final Bson filter, final Bson update) {
        return this.dispatcher.dispatchTask((Callable)new Callable<RemoteUpdateResult>(){

            @Override
            public RemoteUpdateResult call() {
                return RemoteMongoCollectionImpl.this.proxy.updateMany(filter, update);
            }
        });
    }

    @Override
    public Task<RemoteUpdateResult> updateMany(final Bson filter, final Bson update, final RemoteUpdateOptions updateOptions) {
        return this.dispatcher.dispatchTask((Callable)new Callable<RemoteUpdateResult>(){

            @Override
            public RemoteUpdateResult call() {
                return RemoteMongoCollectionImpl.this.proxy.updateMany(filter, update, updateOptions);
            }
        });
    }
}

