/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MappingIterable;
import com.mongodb.MongoBatchCursorAdapter;
import com.mongodb.OperationExecutor;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.ReadOperation;
import com.mongodb.session.ClientSession;
import java.util.Collection;
import java.util.Iterator;

abstract class MongoIterableImpl<TResult>
implements MongoIterable<TResult> {
    private final ClientSession clientSession;
    private final ReadConcern readConcern;
    private OperationExecutor executor;
    private ReadPreference readPreference;
    private Integer batchSize;

    MongoIterableImpl(ClientSession clientSession, OperationExecutor executor, ReadConcern readConcern, ReadPreference readPreference) {
        this.clientSession = clientSession;
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
    }

    abstract ReadOperation<BatchCursor<TResult>> asReadOperation();

    ClientSession getClientSession() {
        return this.clientSession;
    }

    OperationExecutor getExecutor() {
        return this.executor;
    }

    ReadPreference getReadPreference() {
        return this.readPreference;
    }

    ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    public MongoIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return new MongoBatchCursorAdapter<TResult>(this.execute());
    }

    @Override
    public TResult first() {
        Iterator cursor = this.iterator();
        try {
            if (!cursor.hasNext()) {
                TResult TResult = null;
                return TResult;
            }
            Object TResult = cursor.next();
            return TResult;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super TResult> block) {
        Iterator cursor = this.iterator();
        try {
            while (cursor.hasNext()) {
                block.apply(cursor.next());
            }
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public <A extends Collection<? super TResult>> A into(final A target) {
        this.forEach(new Block<TResult>(){

            public void apply(TResult t) {
                target.add(t);
            }
        });
        return target;
    }

    private BatchCursor<TResult> execute() {
        return this.executor.execute(this.asReadOperation(), this.readPreference, this.clientSession);
    }
}

