/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationIterable;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.FullDocument;
import com.mongodb.operation.ChangeStreamOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class ChangeStreamIterableImpl<TResult>
implements ChangeStreamIterable<TResult> {
    private final MongoNamespace namespace;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private final List<? extends Bson> pipeline;
    private final Class<TResult> resultClass;
    private Integer batchSize;
    private FullDocument fullDocument = FullDocument.DEFAULT;
    private Bson resumeToken;
    private long maxAwaitTimeMS;
    private Collation collation;

    ChangeStreamIterableImpl(MongoNamespace namespace, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.pipeline = (List)Assertions.notNull((String)"pipeline", pipeline);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
    }

    @Override
    public ChangeStreamIterable<TResult> fullDocument(FullDocument fullDocument) {
        this.fullDocument = (FullDocument)Assertions.notNull((String)"fullDocument", (Object)fullDocument);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> resumeAfter(Bson resumeAfter) {
        this.resumeToken = (Bson)Assertions.notNull((String)"resumeAfter", (Object)resumeAfter);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> batchSize(int batchSize) {
        this.batchSize = (Integer)Assertions.notNull((String)"batchSize", (Object)batchSize);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> collation(Collation collation) {
        this.collation = (Collation)Assertions.notNull((String)"collation", (Object)collation);
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return this.execute().iterator();
    }

    @Override
    public TResult first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return this.execute().map(mapper);
    }

    @Override
    public void forEach(Block<? super TResult> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super TResult>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<TResult> execute() {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        ChangeStreamOperation changeStreamOperation = new ChangeStreamOperation(this.namespace, this.fullDocument, aggregateList, (Decoder)this.codecRegistry.get(this.resultClass)).maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS).batchSize(this.batchSize).readConcern(this.readConcern).collation(this.collation);
        if (this.resumeToken != null) {
            changeStreamOperation.resumeAfter(this.resumeToken.toBsonDocument(BsonDocument.class, this.codecRegistry));
        }
        return new OperationIterable(changeStreamOperation, this.readPreference, this.executor);
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            if (bson == null) {
                throw new IllegalArgumentException("pipeline can not contain a null value");
            }
            aggregateList.add(bson.toBsonDocument(BsonDocument.class, this.codecRegistry));
        }
        return aggregateList;
    }
}

