/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.internal.SimpleMongoClient;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

class KeyRetriever
implements Closeable {
    private final SimpleMongoClient client;
    private final boolean ownsClient;
    private final MongoNamespace namespace;

    KeyRetriever(SimpleMongoClient client, boolean ownsClient, MongoNamespace namespace) {
        this.client = (SimpleMongoClient)Assertions.notNull((String)"client", (Object)client);
        this.ownsClient = ownsClient;
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
    }

    public Iterator<BsonDocument> find(BsonDocument keyFilter) {
        return this.client.getDatabase(this.namespace.getDatabaseName()).getCollection(this.namespace.getCollectionName(), BsonDocument.class).find((Bson)keyFilter).into(new ArrayList()).iterator();
    }

    @Override
    public void close() {
        if (this.ownsClient) {
            this.client.close();
        }
    }
}

