/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.FindIterableImpl;
import com.mongodb.Function;
import com.mongodb.MappingIterable;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationIterable;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.FindOptions;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AggregateToCollectionOperation;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.WriteOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;

class AggregateIterableImpl<T>
implements AggregateIterable<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private final List<?> pipeline;
    private Boolean allowDiskUse;
    private Integer batchSize;
    private long maxTimeMS;
    private Boolean useCursor;

    AggregateIterableImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor, List<?> pipeline) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.clazz = (Class)Assertions.notNull((String)"clazz", clazz);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.pipeline = (List)Assertions.notNull((String)"pipeline", pipeline);
    }

    @Override
    public AggregateIterable<T> allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public AggregateIterable<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public AggregateIterable<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<T> useCursor(Boolean useCursor) {
        this.useCursor = useCursor;
        return this;
    }

    @Override
    public MongoCursor<T> iterator() {
        return this.execute().iterator();
    }

    @Override
    public T first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return new MappingIterable<T, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super T> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super T>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<T> execute() {
        BsonValue outCollection;
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        BsonValue bsonValue = outCollection = aggregateList.size() == 0 ? null : aggregateList.get(aggregateList.size() - 1).get((Object)"$out");
        if (outCollection != null) {
            AggregateToCollectionOperation operation = new AggregateToCollectionOperation(this.namespace, aggregateList).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse);
            this.executor.execute((WriteOperation)operation);
            return new FindIterableImpl<T>(new MongoNamespace(this.namespace.getDatabaseName(), outCollection.asString().getValue()), this.clazz, this.codecRegistry, this.readPreference, this.executor, new BsonDocument(), new FindOptions()).batchSize(this.batchSize);
        }
        return new OperationIterable(new AggregateOperation(this.namespace, aggregateList, (Decoder)this.codecRegistry.get(this.clazz)).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse).batchSize(this.batchSize).useCursor(this.useCursor), this.readPreference, this.executor);
    }

    private <D> List<BsonDocument> createBsonDocumentList(List<D> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (D obj : pipeline) {
            aggregateList.add(BsonDocumentWrapper.asBsonDocument(obj, (CodecRegistry)this.codecRegistry));
        }
        return aggregateList;
    }
}

