/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.FindFluent;
import com.mongodb.client.ListIndexesFluent;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.AggregateOptions;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DistinctOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.MapReduceOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;

@ThreadSafe
public interface MongoCollection<T> {
    public MongoNamespace getNamespace();

    public Class<T> getDefaultClass();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public <C> MongoCollection<C> withDefaultClass(Class<C> var1);

    public MongoCollection<T> withCodecRegistry(CodecRegistry var1);

    public MongoCollection<T> withReadPreference(ReadPreference var1);

    public MongoCollection<T> withWriteConcern(WriteConcern var1);

    public long count();

    public long count(Object var1);

    public long count(Object var1, CountOptions var2);

    public List<Object> distinct(String var1, Object var2);

    public List<Object> distinct(String var1, Object var2, DistinctOptions var3);

    public FindFluent<T> find();

    public <C> FindFluent<C> find(Class<C> var1);

    public FindFluent<T> find(Object var1);

    public <C> FindFluent<C> find(Object var1, Class<C> var2);

    public MongoIterable<Document> aggregate(List<?> var1);

    public <C> MongoIterable<C> aggregate(List<?> var1, Class<C> var2);

    public MongoIterable<Document> aggregate(List<?> var1, AggregateOptions var2);

    public <C> MongoIterable<C> aggregate(List<?> var1, AggregateOptions var2, Class<C> var3);

    public MongoIterable<Document> mapReduce(String var1, String var2);

    public MongoIterable<Document> mapReduce(String var1, String var2, MapReduceOptions var3);

    public <C> MongoIterable<C> mapReduce(String var1, String var2, Class<C> var3);

    public <C> MongoIterable<C> mapReduce(String var1, String var2, MapReduceOptions var3, Class<C> var4);

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends T>> var1);

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends T>> var1, BulkWriteOptions var2);

    public void insertOne(T var1);

    public void insertMany(List<? extends T> var1);

    public void insertMany(List<? extends T> var1, InsertManyOptions var2);

    public DeleteResult deleteOne(Object var1);

    public DeleteResult deleteMany(Object var1);

    public UpdateResult replaceOne(Object var1, T var2);

    public UpdateResult replaceOne(Object var1, T var2, UpdateOptions var3);

    public UpdateResult updateOne(Object var1, Object var2);

    public UpdateResult updateOne(Object var1, Object var2, UpdateOptions var3);

    public UpdateResult updateMany(Object var1, Object var2);

    public UpdateResult updateMany(Object var1, Object var2, UpdateOptions var3);

    public T findOneAndDelete(Object var1);

    public T findOneAndDelete(Object var1, FindOneAndDeleteOptions var2);

    public T findOneAndReplace(Object var1, T var2);

    public T findOneAndReplace(Object var1, T var2, FindOneAndReplaceOptions var3);

    public T findOneAndUpdate(Object var1, Object var2);

    public T findOneAndUpdate(Object var1, Object var2, FindOneAndUpdateOptions var3);

    public void dropCollection();

    public void createIndex(Object var1);

    public void createIndex(Object var1, CreateIndexOptions var2);

    public ListIndexesFluent<Document> listIndexes();

    public <C> ListIndexesFluent<C> listIndexes(Class<C> var1);

    public void dropIndex(String var1);

    public void dropIndexes();

    public void renameCollection(MongoNamespace var1);

    public void renameCollection(MongoNamespace var1, RenameCollectionOptions var2);
}

