/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.CursorType;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationIterable;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.FindFluent;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.FindOptions;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.FindOperation;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.ReadOperation;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;

final class FindFluentImpl<T>
implements FindFluent<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private final FindOptions findOptions;
    private Object filter;

    FindFluentImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor, Object filter, FindOptions findOptions) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.clazz = (Class)Assertions.notNull((String)"clazz", clazz);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.filter = Assertions.notNull((String)"filter", (Object)filter);
        this.findOptions = (FindOptions)Assertions.notNull((String)"findOptions", (Object)findOptions);
    }

    @Override
    public FindFluent<T> filter(Object filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public FindFluent<T> limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    @Override
    public FindFluent<T> skip(int skip) {
        this.findOptions.skip(skip);
        return this;
    }

    @Override
    public FindFluent<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public FindFluent<T> batchSize(int batchSize) {
        this.findOptions.batchSize(batchSize);
        return this;
    }

    @Override
    public FindFluent<T> modifiers(Object modifiers) {
        this.findOptions.modifiers(modifiers);
        return this;
    }

    @Override
    public FindFluent<T> projection(Object projection) {
        this.findOptions.projection(projection);
        return this;
    }

    @Override
    public FindFluent<T> sort(Object sort) {
        this.findOptions.sort(sort);
        return this;
    }

    @Override
    public FindFluent<T> noCursorTimeout(boolean noCursorTimeout) {
        this.findOptions.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    public FindFluent<T> oplogReplay(boolean oplogReplay) {
        this.findOptions.oplogReplay(oplogReplay);
        return this;
    }

    @Override
    public FindFluent<T> partial(boolean partial) {
        this.findOptions.partial(partial);
        return this;
    }

    @Override
    public FindFluent<T> cursorType(CursorType cursorType) {
        this.findOptions.cursorType(cursorType);
        return this;
    }

    @Override
    public MongoCursor<T> iterator() {
        return this.execute().iterator();
    }

    @Override
    public T first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return this.execute().map(mapper);
    }

    @Override
    public void forEach(Block<? super T> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super T>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<T> execute() {
        return new FindOperationIterable(this.createQueryOperation(), this.readPreference, this.executor);
    }

    private <C> Codec<C> getCodec(Class<C> clazz) {
        return this.codecRegistry.get(clazz);
    }

    private FindOperation<T> createQueryOperation() {
        return new FindOperation(this.namespace, this.getCodec(this.clazz)).filter(this.asBson(this.filter)).batchSize(this.findOptions.getBatchSize()).skip(this.findOptions.getSkip()).limit(this.findOptions.getLimit()).maxTime(this.findOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).modifiers(this.asBson(this.findOptions.getModifiers())).projection(this.asBson(this.findOptions.getProjection())).sort(this.asBson(this.findOptions.getSort())).cursorType(this.findOptions.getCursorType()).noCursorTimeout(this.findOptions.isNoCursorTimeout()).oplogReplay(this.findOptions.isOplogReplay()).partial(this.findOptions.isPartial()).slaveOk(this.readPreference.isSlaveOk());
    }

    private BsonDocument asBson(Object document) {
        return BsonDocumentWrapper.asBsonDocument((Object)document, (CodecRegistry)this.codecRegistry);
    }

    private final class FindOperationIterable
    extends OperationIterable<T> {
        private final ReadPreference readPreference;
        private final OperationExecutor executor;

        FindOperationIterable(FindOperation<T> operation, ReadPreference readPreference, OperationExecutor executor) {
            super(operation, readPreference, executor);
            this.readPreference = readPreference;
            this.executor = executor;
        }

        @Override
        public T first() {
            FindOperation findFirstOperation = FindFluentImpl.this.createQueryOperation().batchSize(0).limit(-1);
            BatchCursor batchCursor = (BatchCursor)this.executor.execute((ReadOperation)findFirstOperation, this.readPreference);
            return batchCursor.hasNext() ? (Object)batchCursor.next().iterator().next() : null;
        }
    }
}

