/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.TimeoutHelper;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

class CollectionInfoRetriever {
    private static final String TIMEOUT_ERROR_MESSAGE = "Collection information retrieval exceeded the timeout limit.";
    private final MongoClient client;

    CollectionInfoRetriever(MongoClient client) {
        this.client = (MongoClient)Assertions.notNull((String)"client", (Object)client);
    }

    public List<BsonDocument> filter(String databaseName, BsonDocument filter, @Nullable Timeout operationTimeout) {
        return TimeoutHelper.databaseWithTimeout(this.client.getDatabase(databaseName), TIMEOUT_ERROR_MESSAGE, operationTimeout).listCollections(BsonDocument.class).filter((Bson)filter).into(new ArrayList());
    }
}

