/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import com.mongodb.DBObjectCodec;
import com.mongodb.annotations.Immutable;
import java.io.StringWriter;
import java.io.Writer;
import org.bson.BsonWriter;
import org.bson.LazyBSONCallback;
import org.bson.LazyBSONObject;
import org.bson.codecs.EncoderContext;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

@Immutable
public class LazyDBObject
extends LazyBSONObject
implements DBObject {
    private boolean isPartial = false;

    public LazyDBObject(byte[] bytes, LazyBSONCallback callback) {
        super(bytes, callback);
    }

    public LazyDBObject(byte[] bytes, int offset, LazyBSONCallback callback) {
        super(bytes, offset, callback);
    }

    public void markAsPartialObject() {
        this.isPartial = true;
    }

    public boolean isPartialObject() {
        return this.isPartial;
    }

    public String toString() {
        JsonWriter writer = new JsonWriter((Writer)new StringWriter(), JsonWriterSettings.builder().build());
        DBObjectCodec.getDefaultRegistry().get(LazyDBObject.class).encode((BsonWriter)writer, (Object)this, EncoderContext.builder().isEncodingCollectibleDocument(true).build());
        return writer.getWriter().toString();
    }
}

