/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBObjectCodecProvider;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFS;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.BsonWriter;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

public abstract class GridFSFile
implements DBObject {
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DBObjectCodecProvider()));
    private static final Set<String> VALID_FIELDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_id", "filename", "contentType", "length", "chunkSize", "uploadDate", "aliases")));
    final DBObject extra = new BasicDBObject();
    GridFS fs;
    Object id;
    String filename;
    String contentType;
    long length;
    long chunkSize;
    Date uploadDate;

    public void save() {
        if (this.fs == null) {
            throw new MongoException("need fs");
        }
        this.fs.getFilesCollection().save(this);
    }

    public int numChunks() {
        double d = this.length;
        return (int)Math.ceil(d /= (double)this.chunkSize);
    }

    public Object getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getLength() {
        return this.length;
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public Date getUploadDate() {
        return this.uploadDate;
    }

    public List<String> getAliases() {
        return (List)this.extra.get("aliases");
    }

    public DBObject getMetaData() {
        return (DBObject)this.extra.get("metadata");
    }

    public void setMetaData(DBObject metadata) {
        this.extra.put("metadata", (Object)metadata);
    }

    public Object put(String key, Object v) {
        if (key == null) {
            throw new RuntimeException("key should never be null");
        }
        if (key.equals("_id")) {
            this.id = v;
        } else if (key.equals("filename")) {
            this.filename = v == null ? null : v.toString();
        } else if (key.equals("contentType")) {
            this.contentType = (String)v;
        } else if (key.equals("length")) {
            this.length = ((Number)v).longValue();
        } else if (key.equals("chunkSize")) {
            this.chunkSize = ((Number)v).longValue();
        } else if (key.equals("uploadDate")) {
            this.uploadDate = (Date)v;
        } else {
            this.extra.put(key, v);
        }
        return v;
    }

    public Object get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key should never be null");
        }
        if (key.equals("_id")) {
            return this.id;
        }
        if (key.equals("filename")) {
            return this.filename;
        }
        if (key.equals("contentType")) {
            return this.contentType;
        }
        if (key.equals("length")) {
            return this.length;
        }
        if (key.equals("chunkSize")) {
            return this.chunkSize;
        }
        if (key.equals("uploadDate")) {
            return this.uploadDate;
        }
        return this.extra.get(key);
    }

    public boolean containsField(String s) {
        return this.keySet().contains(s);
    }

    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(VALID_FIELDS);
        keys.addAll(this.extra.keySet());
        return keys;
    }

    public boolean isPartialObject() {
        return false;
    }

    public void markAsPartialObject() {
        throw new MongoException("Can't load partial GridFSFile file");
    }

    public String toString() {
        JsonWriter writer = new JsonWriter((Writer)new StringWriter(), JsonWriterSettings.builder().build());
        DEFAULT_REGISTRY.get(GridFSFile.class).encode((BsonWriter)writer, (Object)this, EncoderContext.builder().isEncodingCollectibleDocument(true).build());
        return writer.getWriter().toString();
    }

    protected void setGridFS(GridFS fs) {
        this.fs = fs;
    }

    protected GridFS getGridFS() {
        return this.fs;
    }

    public void putAll(BSONObject o) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    public Map<?, ?> toMap() {
        throw new UnsupportedOperationException();
    }

    public Object removeField(String key) {
        throw new UnsupportedOperationException();
    }
}

