/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kotlin.client;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Alpha;
import com.mongodb.annotations.Reason;
import com.mongodb.kotlin.client.ChangeStreamIterable;
import com.mongodb.kotlin.client.ClientSession;
import com.mongodb.kotlin.client.ListDatabasesIterable;
import com.mongodb.kotlin.client.MongoDatabase;
import com.mongodb.kotlin.client.MongoIterable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0007\u00a2\u0006\u0002\b J\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H!0\u001e\"\n\b\u0000\u0010!\u0018\u0001*\u00020\u0001H\u0086\bJ\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\b\"J#\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H!0\u001e\"\n\b\u0000\u0010!\u0018\u0001*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0086\bJ,\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H!0\u001e\"\b\b\u0000\u0010!*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0$J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H!0\u001e\"\b\b\u0000\u0010!*\u00020\u00012\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0$J\u0010\u0010%\u001a\u00020\u001c2\b\b\u0002\u0010&\u001a\u00020'J\u0019\u0010(\u001a\u0004\u0018\u00010)2\b\b\u0002\u0010*\u001a\u00020+H\u0007\u00a2\u0006\u0002\u0010,J+\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0.2\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0007\u00a2\u0006\u0002\b2J3\u0010-\u001a\b\u0012\u0004\u0012\u0002H!0.\"\n\b\u0000\u0010!\u0018\u0001*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0086\bJ<\u0010-\u001a\b\u0012\u0004\u0012\u0002H!0.\"\b\b\u0000\u0010!*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u000201002\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0$J#\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0.2\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0007\u00a2\u0006\u0002\b3J+\u0010-\u001a\b\u0012\u0004\u0012\u0002H!0.\"\n\b\u0000\u0010!\u0018\u0001*\u00020\u00012\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0086\bJ4\u0010-\u001a\b\u0012\u0004\u0012\u0002H!0.\"\b\b\u0000\u0010!*\u00020\u00012\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u000201002\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0$J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0006J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\nJ\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u000eJ\u001a\u0010:\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+H\u0007J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0012R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006="}, d2={"Lcom/mongodb/kotlin/client/MongoCluster;", "", "wrapped", "Lcom/mongodb/client/MongoCluster;", "(Lcom/mongodb/client/MongoCluster;)V", "codecRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "getCodecRegistry", "()Lorg/bson/codecs/configuration/CodecRegistry;", "readConcern", "Lcom/mongodb/ReadConcern;", "getReadConcern", "()Lcom/mongodb/ReadConcern;", "readPreference", "Lcom/mongodb/ReadPreference;", "getReadPreference", "()Lcom/mongodb/ReadPreference;", "writeConcern", "Lcom/mongodb/WriteConcern;", "getWriteConcern", "()Lcom/mongodb/WriteConcern;", "getDatabase", "Lcom/mongodb/kotlin/client/MongoDatabase;", "databaseName", "", "listDatabaseNames", "Lcom/mongodb/kotlin/client/MongoIterable;", "clientSession", "Lcom/mongodb/kotlin/client/ClientSession;", "listDatabases", "Lcom/mongodb/kotlin/client/ListDatabasesIterable;", "Lorg/bson/Document;", "listDatabasesAsDocument", "T", "listDatabasesAsDocumentWithSession", "resultClass", "Ljava/lang/Class;", "startSession", "options", "Lcom/mongodb/ClientSessionOptions;", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/util/concurrent/TimeUnit;)Ljava/lang/Long;", "watch", "Lcom/mongodb/kotlin/client/ChangeStreamIterable;", "pipeline", "", "Lorg/bson/conversions/Bson;", "watchAsDocumentWithSession", "watchAsDocument", "withCodecRegistry", "newCodecRegistry", "withReadConcern", "newReadConcern", "withReadPreference", "newReadPreference", "withTimeout", "withWriteConcern", "newWriteConcern", "mongodb-driver-kotlin-sync"})
@SourceDebugExtension(value={"SMAP\nMongoCluster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoCluster.kt\ncom/mongodb/kotlin/client/MongoCluster\n*L\n1#1,307:1\n220#1:308\n230#1:309\n291#1:310\n305#1:311\n*S KotlinDebug\n*F\n+ 1 MongoCluster.kt\ncom/mongodb/kotlin/client/MongoCluster\n*L\n181#1:308\n191#1:309\n240#1:310\n252#1:311\n*E\n"})
public class MongoCluster {
    @NotNull
    private final com.mongodb.client.MongoCluster wrapped;

    protected MongoCluster(@NotNull com.mongodb.client.MongoCluster wrapped) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        this.wrapped = wrapped;
    }

    @NotNull
    public final CodecRegistry getCodecRegistry() {
        CodecRegistry codecRegistry = this.wrapped.getCodecRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)codecRegistry, (String)"wrapped.codecRegistry");
        return codecRegistry;
    }

    @NotNull
    public final ReadConcern getReadConcern() {
        ReadConcern readConcern = this.wrapped.getReadConcern();
        Intrinsics.checkNotNullExpressionValue((Object)readConcern, (String)"wrapped.readConcern");
        return readConcern;
    }

    @NotNull
    public final ReadPreference getReadPreference() {
        ReadPreference readPreference = this.wrapped.getReadPreference();
        Intrinsics.checkNotNullExpressionValue((Object)readPreference, (String)"wrapped.readPreference");
        return readPreference;
    }

    @NotNull
    public final WriteConcern getWriteConcern() {
        WriteConcern writeConcern = this.wrapped.getWriteConcern();
        Intrinsics.checkNotNullExpressionValue((Object)writeConcern, (String)"wrapped.writeConcern");
        return writeConcern;
    }

    @Alpha(value={Reason.CLIENT})
    @Nullable
    public final Long timeout(@NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        return this.wrapped.getTimeout(timeUnit);
    }

    public static /* synthetic */ Long timeout$default(MongoCluster mongoCluster, TimeUnit timeUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: timeout");
        }
        if ((n & 1) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return mongoCluster.timeout(timeUnit);
    }

    @NotNull
    public final MongoCluster withCodecRegistry(@NotNull CodecRegistry newCodecRegistry) {
        Intrinsics.checkNotNullParameter((Object)newCodecRegistry, (String)"newCodecRegistry");
        com.mongodb.client.MongoCluster mongoCluster = this.wrapped.withCodecRegistry(newCodecRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCluster, (String)"wrapped.withCodecRegistry(newCodecRegistry)");
        return new MongoCluster(mongoCluster);
    }

    @NotNull
    public final MongoCluster withReadPreference(@NotNull ReadPreference newReadPreference) {
        Intrinsics.checkNotNullParameter((Object)newReadPreference, (String)"newReadPreference");
        com.mongodb.client.MongoCluster mongoCluster = this.wrapped.withReadPreference(newReadPreference);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCluster, (String)"wrapped.withReadPreference(newReadPreference)");
        return new MongoCluster(mongoCluster);
    }

    @NotNull
    public final MongoCluster withReadConcern(@NotNull ReadConcern newReadConcern) {
        Intrinsics.checkNotNullParameter((Object)newReadConcern, (String)"newReadConcern");
        com.mongodb.client.MongoCluster mongoCluster = this.wrapped.withReadConcern(newReadConcern);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCluster, (String)"wrapped.withReadConcern(newReadConcern)");
        return new MongoCluster(mongoCluster);
    }

    @NotNull
    public final MongoCluster withWriteConcern(@NotNull WriteConcern newWriteConcern) {
        Intrinsics.checkNotNullParameter((Object)newWriteConcern, (String)"newWriteConcern");
        com.mongodb.client.MongoCluster mongoCluster = this.wrapped.withWriteConcern(newWriteConcern);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCluster, (String)"wrapped.withWriteConcern(newWriteConcern)");
        return new MongoCluster(mongoCluster);
    }

    @Alpha(value={Reason.CLIENT})
    @NotNull
    public final MongoCluster withTimeout(long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        com.mongodb.client.MongoCluster mongoCluster = this.wrapped.withTimeout(timeout, timeUnit);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCluster, (String)"wrapped.withTimeout(timeout, timeUnit)");
        return new MongoCluster(mongoCluster);
    }

    public static /* synthetic */ MongoCluster withTimeout$default(MongoCluster mongoCluster, long l, TimeUnit timeUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withTimeout");
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return mongoCluster.withTimeout(l, timeUnit);
    }

    @NotNull
    public final MongoDatabase getDatabase(@NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        com.mongodb.client.MongoDatabase mongoDatabase = this.wrapped.getDatabase(databaseName);
        Intrinsics.checkNotNullExpressionValue((Object)mongoDatabase, (String)"wrapped.getDatabase(databaseName)");
        return new MongoDatabase(mongoDatabase);
    }

    @NotNull
    public final ClientSession startSession(@NotNull ClientSessionOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        com.mongodb.client.ClientSession clientSession = this.wrapped.startSession(options);
        Intrinsics.checkNotNullExpressionValue((Object)clientSession, (String)"wrapped.startSession(options)");
        return new ClientSession(clientSession);
    }

    public static /* synthetic */ ClientSession startSession$default(MongoCluster mongoCluster, ClientSessionOptions clientSessionOptions, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startSession");
        }
        if ((n & 1) != 0) {
            ClientSessionOptions clientSessionOptions2 = ClientSessionOptions.builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)clientSessionOptions2, (String)"builder().build()");
            clientSessionOptions = clientSessionOptions2;
        }
        return mongoCluster.startSession(clientSessionOptions);
    }

    @NotNull
    public final MongoIterable<String> listDatabaseNames() {
        com.mongodb.client.MongoIterable mongoIterable = this.wrapped.listDatabaseNames();
        Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"wrapped.listDatabaseNames()");
        return new MongoIterable<String>(mongoIterable);
    }

    @NotNull
    public final MongoIterable<String> listDatabaseNames(@NotNull ClientSession clientSession) {
        Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
        com.mongodb.client.MongoIterable mongoIterable = this.wrapped.listDatabaseNames(clientSession.getWrapped());
        Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"wrapped.listDatabaseNames(clientSession.wrapped)");
        return new MongoIterable<String>(mongoIterable);
    }

    @JvmName(name="listDatabasesAsDocument")
    @NotNull
    public final ListDatabasesIterable<Document> listDatabasesAsDocument() {
        MongoCluster this_$iv = this;
        boolean $i$f$listDatabases = false;
        return this_$iv.listDatabases(Document.class);
    }

    @JvmName(name="listDatabasesAsDocumentWithSession")
    @NotNull
    public final ListDatabasesIterable<Document> listDatabasesAsDocumentWithSession(@NotNull ClientSession clientSession) {
        Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
        MongoCluster this_$iv = this;
        boolean $i$f$listDatabases = false;
        return this_$iv.listDatabases(clientSession, Document.class);
    }

    @NotNull
    public final <T> ListDatabasesIterable<T> listDatabases(@NotNull Class<T> resultClass) {
        Intrinsics.checkNotNullParameter(resultClass, (String)"resultClass");
        com.mongodb.client.ListDatabasesIterable listDatabasesIterable = this.wrapped.listDatabases(resultClass);
        Intrinsics.checkNotNullExpressionValue((Object)listDatabasesIterable, (String)"wrapped.listDatabases(resultClass)");
        return new ListDatabasesIterable(listDatabasesIterable);
    }

    @NotNull
    public final <T> ListDatabasesIterable<T> listDatabases(@NotNull ClientSession clientSession, @NotNull Class<T> resultClass) {
        Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
        Intrinsics.checkNotNullParameter(resultClass, (String)"resultClass");
        com.mongodb.client.ListDatabasesIterable listDatabasesIterable = this.wrapped.listDatabases(clientSession.getWrapped(), resultClass);
        Intrinsics.checkNotNullExpressionValue((Object)listDatabasesIterable, (String)"wrapped.listDatabases(cl\u2026ion.wrapped, resultClass)");
        return new ListDatabasesIterable(listDatabasesIterable);
    }

    public final /* synthetic */ <T> ListDatabasesIterable<T> listDatabases() {
        boolean $i$f$listDatabases = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.listDatabases(Object.class);
    }

    public final /* synthetic */ <T> ListDatabasesIterable<T> listDatabases(ClientSession clientSession) {
        Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
        boolean $i$f$listDatabases = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.listDatabases(clientSession, Object.class);
    }

    @JvmName(name="watchAsDocument")
    @NotNull
    public final ChangeStreamIterable<Document> watchAsDocument(@NotNull List<? extends Bson> pipeline) {
        Intrinsics.checkNotNullParameter(pipeline, (String)"pipeline");
        MongoCluster this_$iv = this;
        boolean $i$f$watch = false;
        return this_$iv.watch(pipeline, Document.class);
    }

    public static /* synthetic */ ChangeStreamIterable watchAsDocument$default(MongoCluster mongoCluster, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: watch");
        }
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return mongoCluster.watchAsDocument(list);
    }

    @JvmName(name="watchAsDocumentWithSession")
    @NotNull
    public final ChangeStreamIterable<Document> watchAsDocumentWithSession(@NotNull ClientSession clientSession, @NotNull List<? extends Bson> pipeline) {
        Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
        Intrinsics.checkNotNullParameter(pipeline, (String)"pipeline");
        MongoCluster this_$iv = this;
        boolean $i$f$watch = false;
        return this_$iv.watch(clientSession, pipeline, Document.class);
    }

    public static /* synthetic */ ChangeStreamIterable watchAsDocumentWithSession$default(MongoCluster mongoCluster, ClientSession clientSession, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: watch");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return mongoCluster.watchAsDocumentWithSession(clientSession, list);
    }

    @NotNull
    public final <T> ChangeStreamIterable<T> watch(@NotNull List<? extends Bson> pipeline, @NotNull Class<T> resultClass) {
        Intrinsics.checkNotNullParameter(pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter(resultClass, (String)"resultClass");
        com.mongodb.client.ChangeStreamIterable changeStreamIterable = this.wrapped.watch(pipeline, resultClass);
        Intrinsics.checkNotNullExpressionValue((Object)changeStreamIterable, (String)"wrapped.watch(pipeline, resultClass)");
        return new ChangeStreamIterable(changeStreamIterable);
    }

    public static /* synthetic */ ChangeStreamIterable watch$default(MongoCluster mongoCluster, List list, Class clazz, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: watch");
        }
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return mongoCluster.watch(list, clazz);
    }

    @NotNull
    public final <T> ChangeStreamIterable<T> watch(@NotNull ClientSession clientSession, @NotNull List<? extends Bson> pipeline, @NotNull Class<T> resultClass) {
        Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
        Intrinsics.checkNotNullParameter(pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter(resultClass, (String)"resultClass");
        com.mongodb.client.ChangeStreamIterable changeStreamIterable = this.wrapped.watch(clientSession.getWrapped(), pipeline, resultClass);
        Intrinsics.checkNotNullExpressionValue((Object)changeStreamIterable, (String)"wrapped.watch(clientSess\u2026d, pipeline, resultClass)");
        return new ChangeStreamIterable(changeStreamIterable);
    }

    public static /* synthetic */ ChangeStreamIterable watch$default(MongoCluster mongoCluster, ClientSession clientSession, List list, Class clazz, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: watch");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return mongoCluster.watch(clientSession, list, clazz);
    }

    public final /* synthetic */ <T> ChangeStreamIterable<T> watch(List<? extends Bson> pipeline) {
        Intrinsics.checkNotNullParameter(pipeline, (String)"pipeline");
        boolean $i$f$watch = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.watch(pipeline, Object.class);
    }

    public static /* synthetic */ ChangeStreamIterable watch$default(MongoCluster $this, List pipeline, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: watch");
        }
        if ((n & 1) != 0) {
            pipeline = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        boolean $i$f$watch = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return $this.watch(pipeline, Object.class);
    }

    public final /* synthetic */ <T> ChangeStreamIterable<T> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
        Intrinsics.checkNotNullParameter(pipeline, (String)"pipeline");
        boolean $i$f$watch = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.watch(clientSession, pipeline, Object.class);
    }

    public static /* synthetic */ ChangeStreamIterable watch$default(MongoCluster $this, ClientSession clientSession, List pipeline, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: watch");
        }
        if ((n & 2) != 0) {
            pipeline = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        boolean $i$f$watch = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return $this.watch(clientSession, pipeline, Object.class);
    }
}

