/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kotlin.client;

import com.mongodb.MongoClientException;
import com.mongodb.kotlin.client.MongoCursor;
import com.mongodb.kotlin.client.MongoCursorImpl;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u000b\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u0010J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0000\"\u0004\b\u0001\u0010\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00120\u0010J%\u0010\u0014\u001a\u0002H\u0015\"\u0010\b\u0001\u0010\u0015*\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u00162\u0006\u0010\u0017\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ+\u0010\u001b\u001a\u0002H\u0012\"\u0004\b\u0001\u0010\u00122\u0018\u0010\u001c\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001d\u0012\u0004\u0012\u0002H\u00120\u0010\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/mongodb/kotlin/client/MongoIterable;", "T", "", "delegate", "Lcom/mongodb/client/MongoIterable;", "(Lcom/mongodb/client/MongoIterable;)V", "batchSize", "", "cursor", "Lcom/mongodb/kotlin/client/MongoCursor;", "first", "()Ljava/lang/Object;", "firstOrNull", "forEach", "", "action", "Lkotlin/Function1;", "map", "R", "transform", "toCollection", "C", "", "destination", "(Ljava/util/Collection;)Ljava/util/Collection;", "toList", "", "use", "consumer", "Lkotlin/sequences/Sequence;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "mongodb-driver-kotlin-sync"})
@SourceDebugExtension(value={"SMAP\nMongoIterable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoIterable.kt\ncom/mongodb/kotlin/client/MongoIterable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public class MongoIterable<T> {
    @NotNull
    private final com.mongodb.client.MongoIterable<T> delegate;

    public MongoIterable(@NotNull com.mongodb.client.MongoIterable<T> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @NotNull
    public MongoCursor<T> cursor() {
        com.mongodb.client.MongoCursor mongoCursor = this.delegate.cursor();
        Intrinsics.checkNotNullExpressionValue((Object)mongoCursor, (String)"delegate.cursor()");
        return new MongoCursorImpl(mongoCursor);
    }

    @Nullable
    public final T firstOrNull() {
        return (T)this.delegate.first();
    }

    public final T first() {
        T t = this.firstOrNull();
        if (t == null) {
            throw new MongoClientException("No results available");
        }
        return t;
    }

    @NotNull
    public MongoIterable<T> batchSize(int batchSize) {
        MongoIterable mongoIterable;
        MongoIterable $this$batchSize_u24lambda_u240 = mongoIterable = this;
        boolean bl = false;
        $this$batchSize_u24lambda_u240.delegate.batchSize(batchSize);
        return mongoIterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R use(@NotNull Function1<? super Sequence<? extends T>, ? extends R> consumer) {
        Object object;
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Closeable closeable = this.cursor();
        Throwable throwable = null;
        try {
            MongoCursor it = (MongoCursor)closeable;
            boolean bl = false;
            object = consumer.invoke((Object)SequencesKt.asSequence((Iterator)it));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (R)object;
    }

    @NotNull
    public final <R> MongoIterable<R> map(@NotNull Function1<? super T, ? extends R> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        com.mongodb.client.MongoIterable mongoIterable = this.delegate.map(arg_0 -> MongoIterable.map$lambda$2(transform, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"delegate.map(transform)");
        return new MongoIterable<T>(mongoIterable);
    }

    public final void forEach(@NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.use((Function1)new Function1<Sequence<? extends T>, Unit>(action){
            final /* synthetic */ Function1<T, Unit> $action;
            {
                this.$action = $action;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Sequence<? extends T> it) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Sequence<? extends T> sequence = it;
                Function1<T, Unit> action$iv = this.$action;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    action$iv.invoke(element$iv);
                }
            }
        });
    }

    @NotNull
    public final <C extends Collection<? super T>> C toCollection(@NotNull C destination) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        return (C)((Collection)this.use((Function1)new Function1<Sequence<? extends T>, C>(destination){
            final /* synthetic */ C $destination;
            {
                this.$destination = $destination;
                super(1);
            }

            @NotNull
            public final C invoke(@NotNull Sequence<? extends T> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (C)SequencesKt.toCollection(it, this.$destination);
            }
        }));
    }

    @NotNull
    public final List<T> toList() {
        return CollectionsKt.toList((Iterable)this.toCollection((Collection)new ArrayList()));
    }

    private static final Object map$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }
}

