/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncSingleBatchCursor;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.CursorHelper;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ReadOperationCursor;
import com.mongodb.internal.operation.SingleBatchCursor;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;

public class ListIndexesOperation<T>
implements ReadOperationCursor<T> {
    private static final String COMMAND_NAME = "listIndexes";
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private int batchSize;
    private BsonValue comment;
    private TimeoutMode timeoutMode = TimeoutMode.CURSOR_LIFETIME;

    public ListIndexesOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public ListIndexesOperation<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public ListIndexesOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public ListIndexesOperation<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public TimeoutMode getTimeoutMode() {
        return this.timeoutMode;
    }

    public ListIndexesOperation<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        if (timeoutMode != null) {
            this.timeoutMode = timeoutMode;
        }
        return this;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding, OperationContext operationContext) {
        OperationContext listIndexesOperationContext = OperationHelper.applyTimeoutModeToOperationContext(this.timeoutMode, operationContext);
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, listIndexesOperationContext.getTimeoutContext());
        Supplier<BatchCursor> read = SyncOperationHelper.decorateReadWithRetries(retryState, listIndexesOperationContext, () -> SyncOperationHelper.withSourceAndConnection(binding::getReadConnectionSource, false, (source, connection, operationContextWithMinRTT) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), operationContextWithMinRTT));
            try {
                return SyncOperationHelper.createReadCommandAndExecute(retryState, operationContextWithMinRTT, source, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), this.transformer(), connection);
            }
            catch (MongoCommandException e) {
                return CommandOperationHelper.rethrowIfNotNamespaceError(e, SingleBatchCursor.createEmptySingleBatchCursor(source.getServerDescription().getAddress(), this.batchSize));
            }
        }, listIndexesOperationContext));
        return read.get();
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, OperationContext operationContext, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        OperationContext listIndexesOperationContext = OperationHelper.applyTimeoutModeToOperationContext(this.timeoutMode, operationContext);
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, operationContext.getTimeoutContext());
        binding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncRead = AsyncOperationHelper.decorateReadWithRetriesAsync(retryState, listIndexesOperationContext, funcCallback -> AsyncOperationHelper.withAsyncSourceAndConnection(binding::getReadConnectionSource, false, listIndexesOperationContext, funcCallback, (source, connection, operationContextWithMinRtt, releasingCallback) -> {
            if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), operationContextWithMinRtt), releasingCallback)) {
                return;
            }
            AsyncOperationHelper.createReadCommandAndExecuteAsync(retryState, operationContextWithMinRtt, source, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), this.asyncTransformer(), connection, (result, t) -> {
                if (t != null && !CommandOperationHelper.isNamespaceError(t)) {
                    releasingCallback.onResult(null, t);
                } else {
                    releasingCallback.onResult(result != null ? result : AsyncSingleBatchCursor.createEmptyAsyncSingleBatchCursor(this.getBatchSize()), null);
                }
            });
        })).whenComplete(binding::release);
        asyncRead.get(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument commandDocument = new BsonDocument(this.getCommandName(), (BsonValue)new BsonString(this.namespace.getCollectionName())).append("cursor", (BsonValue)CursorHelper.getCursorDocumentFromBatchSize(this.batchSize == 0 ? null : Integer.valueOf(this.batchSize)));
            DocumentHelper.putIfNotNull(commandDocument, "comment", this.comment);
            return commandDocument;
        };
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return (result, source, connection, operationContext) -> SyncOperationHelper.cursorDocumentToBatchCursor(this.timeoutMode, result, this.batchSize, this.decoder, this.comment, source, connection, operationContext);
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection, operationContext) -> AsyncOperationHelper.cursorDocumentToAsyncBatchCursor(this.timeoutMode, result, this.batchSize, this.decoder, this.comment, source, connection, operationContext);
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, "firstBatch");
    }
}

