/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncSingleBatchCursor;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.CursorHelper;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ReadOperationCursor;
import com.mongodb.internal.operation.SingleBatchCursor;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;

public class ListCollectionsOperation<T>
implements ReadOperationCursor<T> {
    private static final String COMMAND_NAME = "listCollections";
    private final String databaseName;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private BsonDocument filter;
    private int batchSize;
    private boolean nameOnly;
    private boolean authorizedCollections;
    private BsonValue comment;
    private TimeoutMode timeoutMode = TimeoutMode.CURSOR_LIFETIME;

    public ListCollectionsOperation(String databaseName, Decoder<T> decoder) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public MongoNamespace getNamespace() {
        return new MongoNamespace(this.databaseName, "$cmd");
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public boolean isNameOnly() {
        return this.nameOnly;
    }

    public ListCollectionsOperation<T> filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public ListCollectionsOperation<T> nameOnly(boolean nameOnly) {
        this.nameOnly = nameOnly;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public ListCollectionsOperation<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public ListCollectionsOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public ListCollectionsOperation<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public ListCollectionsOperation<T> authorizedCollections(boolean authorizedCollections) {
        this.authorizedCollections = authorizedCollections;
        return this;
    }

    public boolean isAuthorizedCollections() {
        return this.authorizedCollections;
    }

    public TimeoutMode getTimeoutMode() {
        return this.timeoutMode;
    }

    public ListCollectionsOperation<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        if (timeoutMode != null) {
            this.timeoutMode = timeoutMode;
        }
        return this;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding, OperationContext operationContext) {
        OperationContext listCollectionsOperationContext = OperationHelper.applyTimeoutModeToOperationContext(this.timeoutMode, operationContext);
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, listCollectionsOperationContext.getTimeoutContext());
        Supplier<BatchCursor> read = SyncOperationHelper.decorateReadWithRetries(retryState, listCollectionsOperationContext, () -> SyncOperationHelper.withSourceAndConnection(binding::getReadConnectionSource, false, (source, connection, operationContextWithMinRTT) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), operationContextWithMinRTT));
            try {
                return SyncOperationHelper.createReadCommandAndExecute(retryState, operationContextWithMinRTT, source, this.databaseName, this.getCommandCreator(), this.createCommandDecoder(), this.transformer(), connection);
            }
            catch (MongoCommandException e) {
                return CommandOperationHelper.rethrowIfNotNamespaceError(e, SingleBatchCursor.createEmptySingleBatchCursor(source.getServerDescription().getAddress(), this.batchSize));
            }
        }, listCollectionsOperationContext));
        return read.get();
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, OperationContext operationContext, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        OperationContext listCollectionsOperationContext = OperationHelper.applyTimeoutModeToOperationContext(this.timeoutMode, operationContext);
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, listCollectionsOperationContext.getTimeoutContext());
        binding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncRead = AsyncOperationHelper.decorateReadWithRetriesAsync(retryState, listCollectionsOperationContext, funcCallback -> AsyncOperationHelper.withAsyncSourceAndConnection(binding::getReadConnectionSource, false, listCollectionsOperationContext, funcCallback, (source, connection, operationContextWithMinRtt, releasingCallback) -> {
            if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), operationContextWithMinRtt), releasingCallback)) {
                return;
            }
            AsyncOperationHelper.createReadCommandAndExecuteAsync(retryState, operationContextWithMinRtt, source, this.databaseName, this.getCommandCreator(), this.createCommandDecoder(), this.asyncTransformer(), connection, (result, t) -> {
                if (t != null && !CommandOperationHelper.isNamespaceError(t)) {
                    releasingCallback.onResult(null, t);
                } else {
                    releasingCallback.onResult(result != null ? result : AsyncSingleBatchCursor.createEmptyAsyncSingleBatchCursor(this.getBatchSize()), null);
                }
            });
        })).whenComplete(binding::release);
        asyncRead.get(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return (result, source, connection, operationContext) -> SyncOperationHelper.cursorDocumentToBatchCursor(this.timeoutMode, result, this.batchSize, this.decoder, this.comment, source, connection, operationContext);
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection, operationContext) -> AsyncOperationHelper.cursorDocumentToAsyncBatchCursor(this.timeoutMode, result, this.batchSize, this.decoder, this.comment, source, connection, operationContext);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument commandDocument = new BsonDocument(this.getCommandName(), (BsonValue)new BsonInt32(1)).append("cursor", (BsonValue)CursorHelper.getCursorDocumentFromBatchSize(this.batchSize == 0 ? null : Integer.valueOf(this.batchSize)));
            DocumentHelper.putIfNotNull(commandDocument, "filter", (BsonValue)this.filter);
            DocumentHelper.putIfTrue(commandDocument, "nameOnly", this.nameOnly);
            DocumentHelper.putIfTrue(commandDocument, "authorizedCollections", this.authorizedCollections);
            DocumentHelper.putIfNotNull(commandDocument, "comment", this.comment);
            return commandDocument;
        };
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, "firstBatch");
    }
}

