/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.CursorType;
import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoQueryException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncCommandBatchCursor;
import com.mongodb.internal.operation.AsyncCommandCursor;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandBatchCursor;
import com.mongodb.internal.operation.CommandCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.ExplainCommandOperation;
import com.mongodb.internal.operation.ExplainHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.OperationReadConcernHelper;
import com.mongodb.internal.operation.ReadOperationExplainable;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.function.Supplier;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

public class FindOperation<T>
implements ReadOperationExplainable<T> {
    private static final String COMMAND_NAME = "find";
    private static final String FIRST_BATCH = "firstBatch";
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private BsonDocument filter;
    private int batchSize;
    private int limit;
    private BsonDocument projection;
    private int skip;
    private BsonDocument sort;
    private CursorType cursorType = CursorType.NonTailable;
    private boolean noCursorTimeout;
    private boolean partial;
    private Collation collation;
    private BsonValue comment;
    private BsonValue hint;
    private BsonDocument variables;
    private BsonDocument max;
    private BsonDocument min;
    private boolean returnKey;
    private boolean showRecordId;
    private Boolean allowDiskUse;
    private TimeoutMode timeoutMode;

    public FindOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindOperation<T> filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public FindOperation<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public FindOperation<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindOperation<T> projection(@Nullable BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public FindOperation<T> skip(int skip) {
        this.skip = skip;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindOperation<T> sort(@Nullable BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public FindOperation<T> cursorType(CursorType cursorType) {
        this.cursorType = Assertions.notNull("cursorType", cursorType);
        return this;
    }

    public FindOperation<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        if (timeoutMode != null) {
            this.timeoutMode = timeoutMode;
        }
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public FindOperation<T> noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public FindOperation<T> partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public FindOperation<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public FindOperation<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public FindOperation<T> hint(@Nullable BsonValue hint) {
        this.hint = hint;
        return this;
    }

    public BsonDocument getLet() {
        return this.variables;
    }

    public FindOperation<T> let(@Nullable BsonDocument variables) {
        this.variables = variables;
        return this;
    }

    public BsonDocument getMax() {
        return this.max;
    }

    public FindOperation<T> max(@Nullable BsonDocument max) {
        this.max = max;
        return this;
    }

    public BsonDocument getMin() {
        return this.min;
    }

    public FindOperation<T> min(@Nullable BsonDocument min) {
        this.min = min;
        return this;
    }

    public boolean isReturnKey() {
        return this.returnKey;
    }

    public FindOperation<T> returnKey(boolean returnKey) {
        this.returnKey = returnKey;
        return this;
    }

    public boolean isShowRecordId() {
        return this.showRecordId;
    }

    public FindOperation<T> showRecordId(boolean showRecordId) {
        this.showRecordId = showRecordId;
        return this;
    }

    public FindOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public Boolean isAllowDiskUse() {
        return this.allowDiskUse;
    }

    public FindOperation<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding, OperationContext operationContext) {
        IllegalStateException invalidTimeoutModeException = this.invalidTimeoutModeException();
        if (invalidTimeoutModeException != null) {
            throw invalidTimeoutModeException;
        }
        OperationContext findOperationContext = this.getFindOperationContext(operationContext);
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, findOperationContext.getTimeoutContext());
        Supplier<BatchCursor> read = SyncOperationHelper.decorateReadWithRetries(retryState, findOperationContext, () -> SyncOperationHelper.withSourceAndConnection(binding::getReadConnectionSource, false, (source, connection, commandOperationContext) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), commandOperationContext));
            try {
                return SyncOperationHelper.createReadCommandAndExecute(retryState, commandOperationContext, source, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, FIRST_BATCH), this.transformer(), connection);
            }
            catch (MongoCommandException e) {
                throw new MongoQueryException(e.getResponse(), e.getServerAddress());
            }
        }, findOperationContext));
        return read.get();
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, OperationContext operationContext, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        IllegalStateException invalidTimeoutModeException = this.invalidTimeoutModeException();
        if (invalidTimeoutModeException != null) {
            callback.onResult(null, invalidTimeoutModeException);
            return;
        }
        OperationContext findOperationContext = this.getFindOperationContext(operationContext);
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, findOperationContext.getTimeoutContext());
        binding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncRead = AsyncOperationHelper.decorateReadWithRetriesAsync(retryState, operationContext, funcCallback -> AsyncOperationHelper.withAsyncSourceAndConnection(binding::getReadConnectionSource, false, findOperationContext, funcCallback, (source, connection, operationContextWithMinRTT, releasingCallback) -> {
            if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), findOperationContext), releasingCallback)) {
                return;
            }
            SingleResultCallback<T> wrappedCallback = FindOperation.exceptionTransformingCallback(releasingCallback);
            AsyncOperationHelper.createReadCommandAndExecuteAsync(retryState, operationContextWithMinRTT, source, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, FIRST_BATCH), this.asyncTransformer(), connection, wrappedCallback);
        })).whenComplete(binding::release);
        asyncRead.get(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private static <T> SingleResultCallback<T> exceptionTransformingCallback(SingleResultCallback<T> callback) {
        return (result, t) -> {
            if (t != null) {
                if (t instanceof MongoCommandException) {
                    MongoCommandException commandException = (MongoCommandException)t;
                    callback.onResult(result, new MongoQueryException(commandException.getResponse(), commandException.getServerAddress()));
                } else {
                    callback.onResult(result, t);
                }
            } else {
                callback.onResult(result, null);
            }
        };
    }

    @Override
    public <R> CommandReadOperation<R> asExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return this.createExplainableOperation(verbosity, resultDecoder);
    }

    <R> CommandReadOperation<R> createExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return new ExplainCommandOperation<R>(this.getNamespace().getDatabaseName(), this.getCommandName(), (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = this.getCommand(operationContext, 0);
            CommandHelper.applyMaxTimeMS(operationContext.getTimeoutContext(), command);
            return ExplainHelper.asExplainCommand(command, verbosity);
        }, resultDecoder);
    }

    private BsonDocument getCommand(OperationContext operationContext, int maxWireVersion) {
        BsonDocument commandDocument = new BsonDocument(this.getCommandName(), (BsonValue)new BsonString(this.namespace.getCollectionName()));
        OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), maxWireVersion, commandDocument);
        DocumentHelper.putIfNotNull(commandDocument, "filter", (BsonValue)this.filter);
        DocumentHelper.putIfNotNullOrEmpty(commandDocument, "sort", this.sort);
        DocumentHelper.putIfNotNullOrEmpty(commandDocument, "projection", this.projection);
        if (this.skip > 0) {
            commandDocument.put("skip", (BsonValue)new BsonInt32(this.skip));
        }
        if (this.limit != 0) {
            commandDocument.put("limit", (BsonValue)new BsonInt32(Math.abs(this.limit)));
        }
        if (this.limit >= 0) {
            if (this.batchSize < 0 && Math.abs(this.batchSize) < this.limit) {
                commandDocument.put("limit", (BsonValue)new BsonInt32(Math.abs(this.batchSize)));
            } else if (this.batchSize != 0) {
                int effectiveBatchSize = Math.abs(this.batchSize);
                if (effectiveBatchSize == this.limit && effectiveBatchSize < Integer.MAX_VALUE) {
                    ++effectiveBatchSize;
                }
                commandDocument.put("batchSize", (BsonValue)new BsonInt32(effectiveBatchSize));
            }
        }
        if (this.limit < 0 || this.batchSize < 0) {
            commandDocument.put("singleBatch", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.isTailableCursor()) {
            commandDocument.put("tailable", (BsonValue)BsonBoolean.TRUE);
            if (this.isAwaitData()) {
                commandDocument.put("awaitData", (BsonValue)BsonBoolean.TRUE);
            }
        }
        if (this.noCursorTimeout) {
            commandDocument.put("noCursorTimeout", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.partial) {
            commandDocument.put("allowPartialResults", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.collation != null) {
            commandDocument.put("collation", (BsonValue)this.collation.asDocument());
        }
        if (this.comment != null) {
            commandDocument.put("comment", this.comment);
        }
        if (this.hint != null) {
            commandDocument.put("hint", this.hint);
        }
        if (this.variables != null) {
            commandDocument.put("let", (BsonValue)this.variables);
        }
        if (this.max != null) {
            commandDocument.put("max", (BsonValue)this.max);
        }
        if (this.min != null) {
            commandDocument.put("min", (BsonValue)this.min);
        }
        if (this.returnKey) {
            commandDocument.put("returnKey", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.showRecordId) {
            commandDocument.put("showRecordId", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.allowDiskUse != null) {
            commandDocument.put("allowDiskUse", (BsonValue)BsonBoolean.valueOf((boolean)this.allowDiskUse));
        }
        return commandDocument;
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> this.getCommand(operationContext, connectionDescription.getMaxWireVersion());
    }

    private boolean isTailableCursor() {
        return this.cursorType.isTailable();
    }

    private boolean isAwaitData() {
        return this.cursorType == CursorType.TailableAwait;
    }

    private TimeoutMode getTimeoutMode() {
        if (this.timeoutMode == null) {
            return this.isTailableCursor() ? TimeoutMode.ITERATION : TimeoutMode.CURSOR_LIFETIME;
        }
        return this.timeoutMode;
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, CommandBatchCursor<T>> transformer() {
        return (result, source, connection, operationContext) -> new CommandBatchCursor<T>(this.getTimeoutMode(), this.getMaxTimeForCursor(operationContext), operationContext, new CommandCursor<T>((BsonDocument)result, this.batchSize, this.decoder, this.comment, source, connection));
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection, operationContext) -> new AsyncCommandBatchCursor<T>(this.getTimeoutMode(), this.getMaxTimeForCursor(operationContext), operationContext, new AsyncCommandCursor<T>((BsonDocument)result, this.batchSize, this.decoder, this.comment, source, connection));
    }

    private long getMaxTimeForCursor(OperationContext operationContext) {
        return this.cursorType == CursorType.TailableAwait ? operationContext.getTimeoutContext().getMaxAwaitTimeMS() : 0L;
    }

    @Nullable
    private IllegalStateException invalidTimeoutModeException() {
        if (this.isTailableCursor() && this.timeoutMode == TimeoutMode.CURSOR_LIFETIME) {
            return new IllegalStateException("Tailable cursors only support the ITERATION value for the timeoutMode option.");
        }
        return null;
    }

    private boolean shouldDisableMaxTimeMS() {
        return this.isTailableCursor() && !this.isAwaitData() || this.timeoutMode == TimeoutMode.ITERATION;
    }

    private OperationContext getFindOperationContext(OperationContext operationContext) {
        if (this.shouldDisableMaxTimeMS()) {
            return operationContext.withOverride(TimeoutContext::withDisabledMaxTime);
        }
        return operationContext;
    }
}

