/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.OperationReadConcernHelper;
import com.mongodb.internal.operation.ReadOperationSimple;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class EstimatedDocumentCountOperation
implements ReadOperationSimple<Long> {
    private static final String COMMAND_NAME = "count";
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private BsonValue comment;

    public EstimatedDocumentCountOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public EstimatedDocumentCountOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public EstimatedDocumentCountOperation comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Long execute(ReadBinding binding, OperationContext operationContext) {
        try {
            return SyncOperationHelper.executeRetryableRead(binding, operationContext, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.transformer(), this.retryReads);
        }
        catch (MongoCommandException e) {
            return Assertions.assertNotNull(CommandOperationHelper.rethrowIfNotNamespaceError(e, 0L));
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, OperationContext operationContext, SingleResultCallback<Long> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, operationContext, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.asyncTransformer(), this.retryReads, (result, t) -> {
            if (CommandOperationHelper.isNamespaceError(t)) {
                callback.onResult(0L, null);
            } else {
                callback.onResult((Long)result, t);
            }
        });
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, Long> transformer() {
        return (result, source, connection, operationContext) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, Long> asyncTransformer() {
        return (result, source, connection, operationContext) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private long transformResult(BsonDocument result, ConnectionDescription connectionDescription) {
        return result.getNumber((Object)"n").longValue();
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument document = new BsonDocument(this.getCommandName(), (BsonValue)new BsonString(this.namespace.getCollectionName()));
            OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), connectionDescription.getMaxWireVersion(), document);
            if (this.comment != null) {
                document.put("comment", this.comment);
            }
            return document;
        };
    }
}

