/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;

public class DropDatabaseOperation
implements WriteOperation<Void> {
    private final String databaseName;
    private final WriteConcern writeConcern;

    public DropDatabaseOperation(String databaseName, @Nullable WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public String getCommandName() {
        return "dropDatabase";
    }

    @Override
    public MongoNamespace getNamespace() {
        return new MongoNamespace(this.databaseName, "$cmd");
    }

    @Override
    public Void execute(WriteBinding binding, OperationContext operationContext) {
        return SyncOperationHelper.withConnection(binding, operationContext, (connection, operationContextWithMinRtt) -> {
            SyncOperationHelper.executeCommand(binding, operationContextWithMinRtt, this.databaseName, this.getCommand(), connection, SyncOperationHelper.writeConcernErrorTransformer(operationContextWithMinRtt.getTimeoutContext()));
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, OperationContext operationContext, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.withAsyncConnection(binding, operationContext, (connection, operationContextWithMinRtt, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                AsyncOperationHelper.executeCommandAsync(binding, operationContextWithMinRtt, this.databaseName, this.getCommand(), connection, AsyncOperationHelper.writeConcernErrorTransformerAsync(operationContextWithMinRtt.getTimeoutContext()), AsyncOperationHelper.releasingCallback(errHandlingCallback, connection));
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("dropDatabase", (BsonValue)new BsonInt32(1));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        return commandDocument;
    }
}

